/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.Java;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.spi.AbstractIntegrationService;
import org.jboss.osgi.framework.spi.FrameworkModuleProvider;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.framework.spi.SystemPaths;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.metadata.spi.ElementParser;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

final class SystemBundlePlugin
extends AbstractIntegrationService<SystemBundleState> {
    private final FrameworkState frameworkState;
    private SystemBundleState bundleState;

    SystemBundlePlugin(FrameworkState frameworkState) {
        super(IntegrationServices.SYSTEM_BUNDLE_INTERNAL);
        this.frameworkState = frameworkState;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<SystemBundleState> builder) {
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.frameworkState.injectedEnvironment);
        builder.addDependency(IntegrationServices.STORAGE_MANAGER_PLUGIN, StorageManager.class, this.frameworkState.injectedStorageManager);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_PLUGIN, FrameworkModuleProvider.class, this.frameworkState.injectedModuleProvider);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.frameworkState.injectedLockManager);
        builder.addDependency(IntegrationServices.MODULE_MANGER_PLUGIN, ModuleManager.class, this.frameworkState.injectedModuleManager);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PLUGIN, SystemPaths.class, this.frameworkState.injectedSystemPaths);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected SystemBundleState createServiceValue(StartContext startContext) throws StartException {
        StorageState storageState = null;
        BundleManagerPlugin bundleManager = this.frameworkState.getBundleManager();
        try {
            OSGiMetaData metadata = this.createMetaData(bundleManager);
            storageState = this.createStorageState();
            SystemBundleRevision brev = new SystemBundleRevision(this.frameworkState, metadata, storageState);
            this.bundleState = new SystemBundleState(this.frameworkState, brev);
            this.bundleState.changeState(8);
            this.addToEnvironment(brev);
            this.bundleState.createBundleContext();
            bundleManager.injectedSystemBundle.inject((Object)this.bundleState);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                StorageManager storagePlugin = this.frameworkState.getStorageManager();
                storagePlugin.deleteStorageState(storageState);
            }
            throw new StartException((Throwable)ex);
        }
        return this.bundleState;
    }

    public void stop(StopContext context) {
        BundleManagerPlugin bundleManager = this.frameworkState.getBundleManager();
        bundleManager.injectedSystemBundle.uninject();
    }

    private StorageState createStorageState() {
        try {
            StorageManager storagePlugin = this.frameworkState.getStorageManager();
            return storagePlugin.createStorageState(0L, "System Bundle", 0, null);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.illegalStateCannotCreateSystemBundleStorage(ex);
        }
    }

    private OSGiMetaData createMetaData(BundleManagerPlugin bundleManager) {
        List pieces;
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)"system.bundle", (Version)Version.emptyVersion);
        SystemPaths systemPackages = this.frameworkState.getSystemPathsPlugin();
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        for (String packageSpec : exportedPackages) {
            builder.addExportPackages(new String[]{packageSpec});
        }
        String syscaps = (String)bundleManager.getProperty("org.osgi.framework.executionenvironment");
        if (syscaps != null) {
            CharSequence namepart;
            LinkedHashMap nameversion = new LinkedHashMap();
            for (String string : ElementParser.parseDelimitedString((String)syscaps, (char)',')) {
                namepart = new StringBuffer();
                StringBuffer versionpart = new StringBuffer();
                OSGiMetaDataBuilder.convertExecutionEnvironmentHeader((String)string, (StringBuffer)namepart, (StringBuffer)versionpart);
                ArrayList<String> versions = (ArrayList<String>)nameversion.get(((StringBuffer)namepart).toString());
                if (versions == null) {
                    versions = new ArrayList<String>();
                    nameversion.put(((StringBuffer)namepart).toString(), versions);
                }
                if (versionpart.length() <= 0) continue;
                versions.add(versionpart.toString());
            }
            for (Map.Entry entry : nameversion.entrySet()) {
                namepart = (String)entry.getKey();
                List versions = (List)entry.getValue();
                String capspec = "osgi.ee;osgi.ee=\"" + (String)namepart + "\"";
                if (versions.size() > 0) {
                    String vlist = "";
                    for (String version : versions) {
                        vlist = vlist + "," + version;
                    }
                    capspec = capspec + ";version" + (versions.size() > 1 ? ":List<Version>=\"" : "=\"") + vlist.substring(1) + "\"";
                }
                builder.addProvidedCapabilities(new String[]{capspec});
            }
        } else {
            String capspec = "osgi.ee;osgi.ee=\"OSGi/Minimum\";version:List<Version>=\"";
            String vlist = "";
            if (Java.isCompatible(2)) {
                vlist = vlist + ",1.1";
            }
            if (Java.isCompatible(3)) {
                vlist = vlist + ",1.2";
            }
            capspec = capspec + vlist.substring(1) + "\"";
            builder.addProvidedCapabilities(new String[]{capspec});
            capspec = "osgi.ee;osgi.ee=\"JavaSE\";version:List<Version>=\"";
            vlist = "";
            if (Java.isCompatible(4)) {
                vlist = vlist + ",1.3";
            }
            if (Java.isCompatible(5)) {
                vlist = vlist + ",1.4";
            }
            if (Java.isCompatible(6)) {
                vlist = vlist + ",1.5";
            }
            if (Java.isCompatible(7)) {
                vlist = vlist + ",1.6";
            }
            capspec = capspec + vlist.substring(1) + "\"";
            builder.addProvidedCapabilities(new String[]{capspec});
        }
        syscaps = (String)bundleManager.getProperty("org.osgi.framework.system.capabilities");
        if (syscaps != null) {
            pieces = ElementParser.parseDelimitedString((String)syscaps, (char)',');
            builder.addProvidedCapabilities(pieces.toArray(new String[pieces.size()]));
        }
        if ((syscaps = (String)bundleManager.getProperty("org.osgi.framework.system.capabilities.extra")) != null) {
            pieces = ElementParser.parseDelimitedString((String)syscaps, (char)',');
            builder.addProvidedCapabilities(pieces.toArray(new String[pieces.size()]));
        }
        return builder.getOSGiMetaData();
    }

    private void addToEnvironment(SystemBundleRevision sysrev) {
        XEnvironment env = this.frameworkState.getEnvironment();
        env.installResources(new XResource[]{sysrev});
    }
}

