/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.Module;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.internal.BundleStateRevision;
import org.jboss.osgi.framework.internal.EntriesProvider;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.ModuleEntriesProvider;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;

abstract class UserBundleRevision
extends BundleStateRevision {
    private final Deployment deployment;
    private final ServiceTarget serviceTarget;
    private final List<RevisionContent> classPathContent;
    private final EntriesProvider entriesProvider;

    UserBundleRevision(FrameworkState frameworkState, OSGiMetaData metadata, StorageState storageState, Deployment deployment, ServiceTarget serviceTarget) throws BundleException {
        super(frameworkState, metadata, storageState);
        assert (deployment != null) : "Null deployment";
        assert (serviceTarget != null) : "Null serviceTarget";
        this.deployment = deployment;
        this.serviceTarget = serviceTarget;
        if (deployment.getRoot() != null) {
            ArrayList<RevisionContent> bundleClassPath = new ArrayList<RevisionContent>();
            this.entriesProvider = this.getBundleClassPath(deployment.getRoot(), metadata, storageState, bundleClassPath);
            this.classPathContent = Collections.unmodifiableList(bundleClassPath);
        } else {
            Module module = (Module)deployment.getAttachment(InternalConstants.MODULE_KEY);
            this.entriesProvider = new ModuleEntriesProvider(module);
            this.classPathContent = Collections.emptyList();
            this.putAttachment(InternalConstants.MODULE_KEY, module);
        }
        deployment.putAttachment(IntegrationConstants.BUNDLE_REVISION_KEY, (Object)this);
        this.putAttachment(IntegrationConstants.DEPLOYMENT_KEY, deployment);
    }

    static UserBundleRevision assertBundleRevision(BundleRevision brev) {
        assert (brev instanceof UserBundleRevision) : "Not an UserBundleRevision: " + brev;
        return (UserBundleRevision)brev;
    }

    UserBundleState getBundleState() {
        return (UserBundleState)this.getBundle();
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    String getLocation() {
        return this.getDeployment().getLocation();
    }

    List<RevisionContent> getClassPathContent() {
        return this.classPathContent;
    }

    RevisionContent getContentById(int contentId) {
        for (RevisionContent aux : this.classPathContent) {
            if (aux.getContentId() != contentId) continue;
            return aux;
        }
        return null;
    }

    abstract void refreshRevision();

    @Override
    void close() {
        super.close();
        for (RevisionContent aux : this.classPathContent) {
            aux.close();
        }
    }

    public Enumeration<String> getEntryPaths(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntryPaths(path);
    }

    public URL getEntry(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntry(path);
    }

    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.findEntries(path, pattern, recurse);
    }

    private RevisionContent getBundleClassPath(VirtualFile rootFile, OSGiMetaData metadata, StorageState storageState, List<RevisionContent> bundleClassPath) {
        assert (rootFile != null) : "Null rootFile";
        long bundleId = storageState.getBundleId();
        RevisionContent rootContent = new RevisionContent(this, metadata, bundleId, 0, rootFile);
        if (metadata.getBundleClassPath() == null) {
            bundleClassPath.add(rootContent);
            return rootContent;
        }
        for (String path : metadata.getBundleClassPath()) {
            if (path.equals(".")) {
                bundleClassPath.add(rootContent);
                continue;
            }
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) continue;
                VirtualFile anotherRoot = AbstractVFS.toVirtualFile((URL)child.toURL());
                RevisionContent revContent = new RevisionContent(this, metadata, bundleId, bundleClassPath.size(), anotherRoot);
                bundleClassPath.add(revContent);
            }
            catch (IOException ex) {
                FrameworkLogger.LOGGER.errorCannotGetClassPathEntry(ex, path, (BundleRevision)this);
            }
        }
        return rootContent;
    }
}

