/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleRevisionValidatorR3;
import org.jboss.osgi.framework.internal.BundleRevisionValidatorR4;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalConstants;
import org.jboss.osgi.framework.internal.RevisionIdentifier;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.framework.spi.NativeCode;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

abstract class UserBundleRevisionFactory<R extends UserBundleRevision> {
    private final FrameworkState frameworkState;
    private final ServiceTarget serviceTarget;
    private final Deployment deployment;
    private final BundleContext targetContext;
    private R bundleRevision;

    UserBundleRevisionFactory(FrameworkState frameworkState, BundleContext targetContext, Deployment deployment, ServiceTarget serviceTarget) {
        assert (frameworkState != null) : "Null frameworkState";
        assert (targetContext != null) : "Null targetContext";
        assert (deployment != null) : "Null deployment";
        assert (serviceTarget != null) : "Null serviceTarget";
        this.frameworkState = frameworkState;
        this.targetContext = targetContext;
        this.serviceTarget = serviceTarget;
        this.deployment = deployment;
    }

    FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    BundleManagerPlugin getBundleManager() {
        return this.frameworkState.getBundleManager();
    }

    R create() throws BundleException {
        FrameworkLogger.LOGGER.debugf("%s for: %s", this.getClass().getSimpleName(), this.deployment);
        StorageState storageState = null;
        try {
            Deployment dep = this.deployment;
            RevisionIdentifier revIdentifier = (RevisionIdentifier)dep.getAttachment(InternalConstants.REVISION_IDENTIFIER_KEY);
            storageState = this.createStorageState(dep, revIdentifier);
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(IntegrationConstants.OSGI_METADATA_KEY);
            this.bundleRevision = this.createBundleRevision(dep, storageState, this.serviceTarget);
            this.bundleRevision.putAttachment(XResource.RESOURCE_IDENTIFIER_KEY, (Object)revIdentifier.getRevisionId());
            this.validateBundleRevision(this.bundleRevision, metadata);
            this.processNativeCode(this.bundleRevision, metadata, dep);
            XBundle bundle2 = (XBundle)dep.getAttachment(IntegrationConstants.BUNDLE_KEY);
            if (bundle2 == null) {
                bundle2 = this.createBundleState((UserBundleRevision)((Object)this.bundleRevision));
                dep.putAttachment(IntegrationConstants.BUNDLE_KEY, (Object)bundle2);
                UserBundleState userBundle = UserBundleState.assertBundleState((Bundle)bundle2);
                this.installBundleRevision(userBundle, this.bundleRevision);
                userBundle.initLazyActivation();
                userBundle.changeState(2, 0);
                FrameworkLogger.LOGGER.infoBundleInstalled((Bundle)bundle2);
                FrameworkEvents events = this.frameworkState.getFrameworkEvents();
                events.fireBundleEvent(this.targetContext, bundle2, 1);
            } else {
                UserBundleState userBundle = UserBundleState.assertBundleState((Bundle)bundle2);
                this.installBundleRevision(userBundle, this.bundleRevision);
            }
        }
        catch (Exception ex) {
            throw this.handleCreateException(storageState, ex);
        }
        return this.bundleRevision;
    }

    private BundleException handleCreateException(StorageState storageState, Exception ex) {
        if (storageState != null) {
            StorageManager storagePlugin = this.frameworkState.getStorageManager();
            storagePlugin.deleteStorageState(storageState);
        }
        if (ex instanceof BundleException) {
            return (BundleException)((Object)ex);
        }
        return FrameworkMessages.MESSAGES.cannotCreateBundleRevisionFromDeployment(ex, this.deployment);
    }

    abstract R createBundleRevision(Deployment var1, StorageState var2, ServiceTarget var3) throws BundleException;

    UserBundleState createBundleState(UserBundleRevision revision) {
        return new UserBundleState(this.frameworkState, revision);
    }

    private StorageState createStorageState(Deployment dep, RevisionIdentifier revIdentifier) throws BundleException {
        StorageState storageState = (StorageState)dep.getAttachment(IntegrationConstants.STORAGE_STATE_KEY);
        if (storageState == null) {
            String location = dep.getLocation();
            VirtualFile rootFile = dep.getRoot();
            try {
                Integer startlevel = dep.getStartLevel();
                StorageManager storageManager = this.frameworkState.getStorageManager();
                storageState = storageManager.createStorageState(revIdentifier.getRevisionId(), location, startlevel, rootFile);
                dep.putAttachment(IntegrationConstants.STORAGE_STATE_KEY, (Object)storageState);
            }
            catch (IOException ex) {
                throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
            }
        }
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installBundleRevision(UserBundleState userBundle, R brev) throws BundleException {
        LockManager lockManager = this.getFrameworkState().getLockManager();
        LockManager.LockContext lockContext = null;
        try {
            brev.putAttachment(IntegrationConstants.BUNDLE_KEY, (Object)userBundle);
            lockContext = lockManager.lockItems(LockManager.Method.INSTALL, userBundle);
            XEnvironment env = this.frameworkState.getEnvironment();
            env.installResources(new XResource[]{brev});
            userBundle.addBundleRevision((UserBundleRevision)((Object)this.bundleRevision));
            lockManager.unlockItems(lockContext);
        }
        catch (Throwable throwable) {
            lockManager.unlockItems(lockContext);
            throw throwable;
        }
    }

    private void validateBundleRevision(R bundleRevision, OSGiMetaData metadata) throws BundleException {
        if (metadata.getBundleManifestVersion() > 1) {
            new BundleRevisionValidatorR4().validateBundleRevision((XBundleRevision)bundleRevision, metadata);
        } else {
            new BundleRevisionValidatorR3().validateBundleRevision((XBundleRevision)bundleRevision, metadata);
        }
    }

    private void processNativeCode(R bundleRevision, OSGiMetaData metadata, Deployment dep) {
        if (metadata.getBundleNativeCode() != null) {
            NativeCode nativeCodePlugin = this.frameworkState.getNativeCode();
            nativeCodePlugin.deployNativeCode(dep);
        }
    }
}

