/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.FrameworkMessages;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.CoreServices;
import org.jboss.osgi.framework.internal.FragmentBundleRevision;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.UserBundleContext;
import org.jboss.osgi.framework.internal.UserBundleRevision;
import org.jboss.osgi.framework.spi.BundleLifecycle;
import org.jboss.osgi.framework.spi.DeploymentProvider;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationConstants;
import org.jboss.osgi.framework.spi.ModuleManager;
import org.jboss.osgi.framework.spi.ServiceState;
import org.jboss.osgi.framework.spi.StartLevelManager;
import org.jboss.osgi.framework.spi.StorageManager;
import org.jboss.osgi.framework.spi.StorageState;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XBundleWiringSupport;
import org.jboss.osgi.resolver.spi.AbstractBundleWiring;
import org.jboss.osgi.resolver.spi.ResolverHookException;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Wire;

class UserBundleState
extends AbstractBundleState<UserBundleRevision> {
    private final AtomicBoolean alreadyStarting = new AtomicBoolean();
    private final AtomicBoolean awaitLazyActivation = new AtomicBoolean();
    private final AtomicInteger revisionIndex = new AtomicInteger();
    private final List<UserBundleRevision> revisions = new ArrayList<UserBundleRevision>();
    private BundleActivator bundleActivator;

    UserBundleState(FrameworkState frameworkState, UserBundleRevision brev) {
        super(frameworkState, brev, brev.getStorageState().getBundleId());
    }

    static UserBundleState assertBundleState(Bundle bundle2) {
        bundle2 = AbstractBundleState.assertBundleState(bundle2);
        assert (bundle2 instanceof UserBundleState) : "Not an UserBundleState: " + bundle2;
        return (UserBundleState)bundle2;
    }

    public String getLocation() {
        return ((UserBundleRevision)((Object)this.getBundleRevision())).getLocation();
    }

    @Override
    public <T> T adapt(Class<T> type) {
        Object result = super.adapt(type);
        if (result == null && type.isAssignableFrom(Deployment.class)) {
            result = this.getDeployment();
        }
        return result;
    }

    Deployment getDeployment() {
        return ((UserBundleRevision)((Object)this.getBundleRevision())).getDeployment();
    }

    @Override
    boolean isSingleton() {
        return this.getOSGiMetaData().isSingleton();
    }

    void initLazyActivation() {
        if (!this.isFragment()) {
            this.awaitLazyActivation.set(this.isActivationLazy());
        }
    }

    boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    boolean awaitLazyActivation() {
        return this.awaitLazyActivation.get();
    }

    void activateLazily() throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.startLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            FrameworkLogger.LOGGER.debugf("Lazy activation of: %s", this);
            this.getBundleManager().startBundleLifecycle(this, options);
        }
    }

    void setBundleActivationPolicyUsed(boolean usePolicy) {
        StorageState storageState = this.getStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    boolean isAlreadyStarting() {
        return this.alreadyStarting.get();
    }

    @Override
    public Dictionary<String, String> getHeaders(String locale) {
        Dictionary<String, String> headersOnUninstall = ((UserBundleRevision)((Object)this.getBundleRevision())).getHeadersOnUninstall();
        if (headersOnUninstall != null) {
            return headersOnUninstall;
        }
        return super.getHeaders(locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    BundleRevisions getBundleRevisions() {
        List<UserBundleRevision> list = this.revisions;
        synchronized (list) {
            UserBundleState bundle2 = this;
            return new BundleRevisions((Bundle)bundle2){
                final /* synthetic */ Bundle val$bundle;
                {
                    this.val$bundle = bundle2;
                }

                public Bundle getBundle() {
                    return this.val$bundle;
                }

                public List<BundleRevision> getRevisions() {
                    ArrayList bundleRevisions = new ArrayList(UserBundleState.this.revisions);
                    return Collections.unmodifiableList(bundleRevisions);
                }

                public String toString() {
                    return this.val$bundle + ": " + UserBundleState.this.revisions;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addBundleRevision(UserBundleRevision brev) {
        List<UserBundleRevision> list = this.revisions;
        synchronized (list) {
            super.addBundleRevision(brev);
            if (!this.isFragment()) {
                ModuleManager moduleManager = this.getFrameworkState().getModuleManager();
                ModuleIdentifier moduleIdentifier = moduleManager.getModuleIdentifier((XBundleRevision)brev);
                brev.putAttachment(IntegrationConstants.MODULE_IDENTIFIER_KEY, moduleIdentifier);
            }
            this.revisionIndex.incrementAndGet();
            this.revisions.add(0, brev);
        }
    }

    int getRevisionIndex() {
        return this.revisionIndex.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<XBundleRevision> getAllBundleRevisions() {
        List<UserBundleRevision> list = this.revisions;
        synchronized (list) {
            ArrayList<UserBundleRevision> result = new ArrayList<UserBundleRevision>(this.revisions);
            return Collections.unmodifiableList(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeRevision(UserBundleRevision rev) {
        List<UserBundleRevision> list = this.revisions;
        synchronized (list) {
            this.revisions.remove((Object)rev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    UserBundleRevision getBundleRevisionById(int revisionId) {
        List<UserBundleRevision> list = this.revisions;
        synchronized (list) {
            for (UserBundleRevision rev : this.revisions) {
                if (rev.getRevisionId() != revisionId) continue;
                return rev;
            }
            return null;
        }
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        int state;
        FrameworkLogger.LOGGER.debugf("Updating bundle: %s", this);
        boolean restart = false;
        if (!(this.isFragment() || (state = this.getState()) != 32 && state != 8 && state != 16)) {
            this.getBundleManager().stopBundle(this, 1);
            if (state != 16) {
                restart = true;
            }
        }
        this.changeState(2, 64);
        UserBundleRevision currentRev = (UserBundleRevision)((Object)this.getBundleRevision());
        try {
            this.createUpdateRevision(input);
            currentRev.getWiringSupport().makeUneffective();
        }
        catch (Exception ex) {
            BundleException be;
            boolean isbe = ex instanceof BundleException;
            BundleException bundleException = be = isbe ? (BundleException)((Object)ex) : FrameworkMessages.MESSAGES.cannotUpdateBundle(ex, (Bundle)this);
            if (restart) {
                this.getBundleManager().startBundle(this, 1);
            }
            throw be;
        }
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.fireBundleEvent(this, 8);
        if (restart) {
            try {
                this.getBundleManager().startBundle(this, 1);
            }
            catch (BundleException e) {
                eventsPlugin.fireFrameworkEvent(this, 2, e, new FrameworkListener[0]);
            }
        }
        this.updateLastModified();
        FrameworkLogger.LOGGER.infoBundleUpdated((Bundle)this);
    }

    private UserBundleRevision createUpdateRevision(InputStream input) throws IOException, BundleException {
        String updateLocation = this.getOSGiMetaData().getHeader("Bundle-UpdateLocation");
        VirtualFile rootFile = null;
        if (input == null) {
            if (updateLocation != null) {
                URL updateURL = new URL(updateLocation);
                rootFile = AbstractVFS.toVirtualFile((URL)updateURL);
            } else {
                rootFile = this.getDeployment().getRoot();
            }
        }
        if (rootFile == null && input != null) {
            rootFile = AbstractVFS.toVirtualFile((InputStream)input);
        }
        StorageState storageState = this.createUpdateStorageState(this.getLocation(), rootFile);
        DeploymentProvider deploymentManager = this.getFrameworkState().getDeploymentProvider();
        Deployment dep = deploymentManager.createDeployment(storageState);
        OSGiMetaData metadata = deploymentManager.createOSGiMetaData(dep);
        dep.putAttachment(IntegrationConstants.OSGI_METADATA_KEY, (Object)metadata);
        dep.putAttachment(IntegrationConstants.BUNDLE_KEY, (Object)this);
        dep.setBundleUpdate(true);
        dep.setAutoStart(false);
        String symbolicName = metadata.getBundleSymbolicName();
        Version bundleVersion = metadata.getBundleVersion();
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.checkUniqunessPolicy((Bundle)this, symbolicName, bundleVersion, 2);
        BundleContext syscontext = this.getFrameworkState().getSystemBundle().getBundleContext();
        BundleLifecycle bundleLifecycle = this.getFrameworkState().getCoreServices().getBundleLifecycle();
        XBundleRevision brev = bundleLifecycle.createBundleRevision(syscontext, dep);
        return UserBundleRevision.assertBundleRevision((BundleRevision)brev);
    }

    private StorageState createUpdateStorageState(String location, VirtualFile rootFile) throws BundleException {
        StorageState storageState;
        try {
            int startLevel = this.adapt(BundleStartLevel.class).getStartLevel();
            StorageManager storageManager = this.getFrameworkState().getStorageManager();
            storageState = storageManager.createStorageState(this.getBundleId(), location, startLevel, rootFile);
        }
        catch (IOException ex) {
            throw FrameworkMessages.MESSAGES.cannotSetupStorage(ex, rootFile);
        }
        return storageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() throws BundleException {
        this.assertNotUninstalled();
        FrameworkLogger.LOGGER.debugf("Refreshing bundle: %s", this);
        CoreServices coreServices = this.getFrameworkState().getCoreServices();
        BundleLifecycle bundleLifecycle = coreServices.getBundleLifecycle();
        BundleLifecycle.BundleRefreshPolicy refreshPolicy = bundleLifecycle.getBundleRefreshPolicy();
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.unresolveBundle(this);
        UserBundleRevision currentRev = (UserBundleRevision)((Object)this.getBundleRevision());
        refreshPolicy.startBundleRefresh(this);
        try {
            for (XBundleRevision brev : this.getAllBundleRevisions()) {
                if (currentRev != brev) {
                    bundleManager.removeRevisionLifecycle(brev, 0);
                }
                if (!(brev instanceof HostBundleRevision)) continue;
                HostBundleRevision hostRev = (HostBundleRevision)brev;
                for (FragmentBundleRevision fragRev : hostRev.getAttachedFragments()) {
                    if (fragRev == fragRev.getBundle().getBundleRevision()) continue;
                    bundleManager.removeRevisionLifecycle((XBundleRevision)fragRev, 0);
                }
            }
            this.awaitLazyActivation.set(false);
            this.revisionIndex.set(1);
            FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
            eventsPlugin.fireBundleEvent(this, 64);
            refreshPolicy.refreshCurrentRevision((XBundleRevision)currentRev);
            this.changeState(2);
        }
        finally {
            refreshPolicy.endBundleRefresh(this);
        }
        FrameworkLogger.LOGGER.infoBundleRefreshed((Bundle)this);
    }

    @Override
    void uninstallInternal(int options) throws BundleException {
        boolean activeWires;
        int state = this.getState();
        if (state == 1) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Uninstalling bundle: %s", this);
        BundleManagerPlugin bundleManager = this.getBundleManager();
        ((UserBundleRevision)((Object)this.getBundleRevision())).setHeadersOnUninstall(this.getHeaders(null));
        if (!(this.isFragment() || state != 32 && state != 8 && state != 16)) {
            try {
                this.stopInternal(options);
            }
            catch (Exception ex) {
                bundleManager.fireFrameworkError(this, "stopping bundle: " + this, ex);
            }
        }
        if (!(activeWires = this.hasActiveWiresWhileUninstalling())) {
            bundleManager.unresolveBundle(this);
        } else {
            FrameworkLogger.LOGGER.debugf("Has active wires: %s", this);
        }
        ((UserBundleRevision)((Object)this.getBundleRevision())).getWiringSupport().makeUneffective();
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.fireBundleEvent(this, 64);
        this.changeState(1, 0);
        if ((options & 1) == 0) {
            StorageManager storagePlugin = this.getFrameworkState().getStorageManager();
            storagePlugin.deleteStorageState(this.getStorageState());
        }
        if (!activeWires) {
            bundleManager.removeBundle(this, options);
        }
        Set<XBundle> uninstalled = bundleManager.getBundles(1);
        for (XBundle auxState : uninstalled) {
            BundleWiring bwiring;
            if (auxState == this) continue;
            boolean bundleInUse = false;
            XBundleRevision brev = auxState.getBundleRevision();
            XBundleWiringSupport wiringSupport = brev.getWiringSupport();
            if (!wiringSupport.isEffective() && (bwiring = (BundleWiring)wiringSupport.getWiring(false)) != null && bwiring.isInUse()) {
                bundleInUse = true;
                break;
            }
            if (bundleInUse) continue;
            UserBundleState auxUser = UserBundleState.assertBundleState((Bundle)auxState);
            bundleManager.unresolveBundle(auxUser);
            bundleManager.removeBundle(auxUser, options);
        }
        this.fireBundleEvent(16);
        FrameworkLogger.LOGGER.infoBundleUninstalled((Bundle)this);
    }

    public boolean isFragment() {
        return ((UserBundleRevision)((Object)this.getBundleRevision())).isFragment();
    }

    UserBundleContext createContextInternal() {
        return new UserBundleContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        try {
            this.alreadyStarting.set(true);
            this.startInternalNow(options);
        }
        finally {
            this.alreadyStarting.set(false);
        }
    }

    private void startInternalNow(int options) throws BundleException {
        boolean useActivationPolicy;
        if (this.getState() == 32) {
            return;
        }
        FrameworkLogger.LOGGER.debugf("Starting bundle: %s", this);
        this.persistAutoStartSettings(options);
        if (!this.startLevelValidForStart()) {
            StartLevelManager plugin = this.getFrameworkState().getStartLevelManager();
            int frameworkState = this.getBundleManager().getSystemBundle().getState();
            Logger.Level level = plugin.isFrameworkStartLevelChanging() || frameworkState != 32 ? Logger.Level.DEBUG : Logger.Level.INFO;
            FrameworkLogger.LOGGER.log(level, FrameworkMessages.MESSAGES.bundleStartLevelNotValid(this.getBundleStartLevel(), plugin.getFrameworkStartLevel(), (Bundle)this));
            return;
        }
        if (!this.ensureResolved(true)) {
            Exception resex = this.getLastResolverException();
            int type = resex instanceof ResolverHookException ? 12 : 4;
            throw new BundleException(FrameworkMessages.MESSAGES.cannotResolveBundle((Bundle)this), type, (Throwable)resex);
        }
        if (this.getBundleContextInternal() == null) {
            this.createBundleContext();
        }
        boolean bl = useActivationPolicy = (options & 2) != 0;
        if (this.awaitLazyActivation.get() && useActivationPolicy) {
            if (this.getState() == 8) {
                return;
            }
            this.changeState(8, 512);
            return;
        }
        try {
            this.changeState(8);
        }
        catch (LifecycleInterceptorException ex) {
            throw FrameworkMessages.MESSAGES.cannotTransitionToStarting(ex, (Bundle)this);
        }
        String className = this.getOSGiMetaData().getBundleActivator();
        if (className != null) {
            try {
                this.bundleActivator = (BundleActivator)this.getDeployment().getAttachment(IntegrationConstants.BUNDLE_ACTIVATOR_KEY);
                if (this.bundleActivator == null) {
                    Object result = this.loadClass(className).newInstance();
                    if (result instanceof BundleActivator) {
                        this.bundleActivator = (BundleActivator)result;
                    } else {
                        throw FrameworkMessages.MESSAGES.invalidBundleActivator(className);
                    }
                }
                if (this.bundleActivator != null) {
                    this.bundleActivator.start(this.getBundleContext());
                }
            }
            catch (Throwable th) {
                this.changeState(16);
                this.removeServicesAndListeners();
                this.destroyBundleContext();
                this.changeState(4);
                if (th instanceof BundleException) {
                    throw (BundleException)th;
                }
                throw new BundleException(FrameworkMessages.MESSAGES.cannotStartBundle((Bundle)this), 5, th);
            }
        }
        if (this.getState() == 1) {
            throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStart((Bundle)this);
        }
        this.changeState(32);
        FrameworkLogger.LOGGER.infoBundleStarted((Bundle)this);
    }

    @Override
    void stopInternal(int options) throws BundleException {
        this.stopInternalNow(options);
    }

    private void stopInternalNow(int options) throws BundleException {
        FrameworkLogger.LOGGER.debugf("Stopping bundle: %s", this);
        int priorState = this.getState();
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(false);
            this.setBundleActivationPolicyUsed(false);
        }
        if (priorState != 8 && priorState != 32) {
            return;
        }
        this.changeState(16);
        Throwable rethrow = null;
        if (priorState == 32 && this.bundleActivator != null) {
            try {
                this.bundleActivator.stop(this.getBundleContext());
            }
            catch (Throwable t) {
                rethrow = t;
            }
        }
        this.removeServicesAndListeners();
        if (this.getState() == 1) {
            throw FrameworkMessages.MESSAGES.uninstalledDuringActivatorStop((Bundle)this);
        }
        this.destroyBundleContext();
        this.changeState(4, 4);
        if (rethrow != null) {
            throw FrameworkMessages.MESSAGES.cannotStopBundle(rethrow, (Bundle)this);
        }
        FrameworkLogger.LOGGER.infoBundleStopped((Bundle)this);
    }

    Set<UserBundleState> getDependentBundles() {
        HashSet<UserBundleState> result = new HashSet<UserBundleState>();
        if (this.isResolved()) {
            BundleWiring wiring = ((UserBundleRevision)((Object)this.getBundleRevision())).getWiring();
            List wires = wiring.getRequiredResourceWires(null);
            for (Wire wire : wires) {
                BundleRevision brev = (BundleRevision)wire.getProvider();
                Bundle bundle2 = brev.getBundle();
                if (!(bundle2 instanceof UserBundleState)) continue;
                result.add((UserBundleState)bundle2);
            }
        }
        return result;
    }

    @Override
    void assertStartConditions(int options) throws BundleException {
        super.assertStartConditions(options);
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[,\\s]+"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw FrameworkMessages.MESSAGES.unsupportedExecutionEnvironment(requiredEnvs, availableEnvs);
            }
        }
        if (!this.startLevelValidForStart()) {
            if ((options & 1) != 0) {
                throw FrameworkMessages.MESSAGES.cannotStartBundleDueToStartLevel();
            }
            this.persistAutoStartSettings(options);
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private int getBundleStartLevel() {
        StartLevelManager startLevelPlugin = this.getFrameworkState().getStartLevelManager();
        return startLevelPlugin.getBundleStartLevel(this);
    }

    void setPersistentlyStarted(boolean started) {
        StartLevelManager startLevelPlugin = this.getFrameworkState().getStartLevelManager();
        startLevelPlugin.setBundlePersistentlyStarted(this, started);
    }

    private boolean startLevelValidForStart() {
        StartLevelManager startLevelPlugin = this.getFrameworkState().getStartLevelManager();
        return startLevelPlugin.getBundleStartLevel(this) <= startLevelPlugin.getFrameworkStartLevel();
    }

    private boolean isBundleActivationPolicyUsed() {
        StorageState storageState = this.getStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    private void removeServicesAndListeners() {
        for (ServiceState<?> serviceState : this.getRegisteredServicesInternal()) {
            serviceState.unregisterInternal();
        }
        FrameworkEvents eventsPlugin = this.getFrameworkState().getFrameworkEvents();
        eventsPlugin.removeBundleListeners(this);
    }

    private boolean hasActiveWiresWhileUninstalling() {
        BundleWiring wiring = this.getBundleWiring();
        return wiring != null ? ((AbstractBundleWiring)wiring).isInUseForUninstall() : false;
    }
}

