/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.FrameworkLogger;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.spi.BootstrapBundlesActivate;
import org.jboss.osgi.framework.spi.BootstrapBundlesService;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.resolver.XBundle;
import org.jboss.osgi.resolver.XBundleRevision;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.service.resolver.ResolutionException;

public class BootstrapBundlesResolve<T>
extends BootstrapBundlesService<T> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkWiring> injectedFrameworkWiring = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XBundle> injectedSystemBundle = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();
    private final Set<XBundleRevision> installedRevisions;

    public BootstrapBundlesResolve(ServiceName baseName, Set<XBundleRevision> installedRevisions) {
        super(baseName, IntegrationServices.BootstrapPhase.RESOLVE);
        this.installedRevisions = installedRevisions;
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<T> builder) {
        builder.addDependency(IntegrationServices.SYSTEM_BUNDLE_INTERNAL, XBundle.class, this.injectedSystemBundle);
        builder.addDependency(IntegrationServices.FRAMEWORK_WIRING_PLUGIN, FrameworkWiring.class, this.injectedFrameworkWiring);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.addDependencies(new ServiceName[]{this.getPreviousService()});
    }

    protected BundleManager getBundleManager() {
        return (BundleManager)this.injectedBundleManager.getValue();
    }

    @Override
    public void start(StartContext context) throws StartException {
        int targetLevel = this.getBeginningStartLevel();
        HashSet<XBundle> resolvableBundles = new HashSet<XBundle>();
        for (XBundleRevision brev : this.installedRevisions) {
            int bundleLevel;
            Deployment dep = (Deployment)brev.getBundle().adapt(Deployment.class);
            int n = bundleLevel = dep.getStartLevel() != null ? dep.getStartLevel() : 1;
            if (!dep.isAutoStart() || brev.isFragment() || bundleLevel > targetLevel) continue;
            resolvableBundles.add(brev.getBundle());
        }
        if (IntegrationServices.BOOTSTRAP_BUNDLES.isParentOf(this.getServiceName())) {
            XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
            ArrayList<XBundleRevision> mandatory = new ArrayList<XBundleRevision>();
            mandatory.add(((XBundle)this.injectedSystemBundle.getValue()).getBundleRevision());
            for (XBundle bundle2 : resolvableBundles) {
                mandatory.add(bundle2.getBundleRevision());
            }
            XResolver resolver = (XResolver)this.injectedResolver.getValue();
            XResolveContext ctx = resolver.createResolveContext(env, mandatory, null);
            try {
                resolver.resolveAndApply(ctx);
            }
            catch (ResolutionException ex) {
                throw new StartException((Throwable)ex);
            }
        }
        if (!resolvableBundles.isEmpty()) {
            if (IntegrationServices.PERSISTENT_BUNDLES.isParentOf(this.getServiceName())) {
                ArrayList<XBundle> bundles = new ArrayList<XBundle>();
                for (XBundle bundle3 : resolvableBundles) {
                    bundles.add(bundle3);
                }
                FrameworkWiring frameworkWiring = (FrameworkWiring)this.injectedFrameworkWiring.getValue();
                frameworkWiring.resolveBundles(bundles);
            }
            Iterator iterator = resolvableBundles.iterator();
            while (iterator.hasNext()) {
                XBundle bundle4 = (XBundle)iterator.next();
                if (bundle4.isResolved()) continue;
                iterator.remove();
            }
        }
        this.installActivateService(context.getChildTarget(), resolvableBundles);
    }

    private int getBeginningStartLevel() {
        String levelSpec = (String)this.getBundleManager().getProperty("org.osgi.framework.startlevel.beginning");
        if (levelSpec != null) {
            try {
                return Integer.parseInt(levelSpec);
            }
            catch (NumberFormatException nfe) {
                FrameworkLogger.LOGGER.errorInvalidBeginningStartLevel(levelSpec);
            }
        }
        return 1;
    }

    protected ServiceController<T> installActivateService(ServiceTarget serviceTarget, Set<XBundle> resolvedBundles) {
        return new BootstrapBundlesActivate(this.getServiceName().getParent(), resolvedBundles).install(serviceTarget, this.getServiceListener());
    }
}

