/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.spi;

import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.FrameworkWiringImpl;
import org.jboss.osgi.framework.spi.BundleManager;
import org.jboss.osgi.framework.spi.ExecutorServicePlugin;
import org.jboss.osgi.framework.spi.FrameworkEvents;
import org.jboss.osgi.framework.spi.IntegrationServices;
import org.jboss.osgi.framework.spi.LockManager;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolver;
import org.osgi.framework.wiring.FrameworkWiring;

public class FrameworkWiringPlugin
extends ExecutorServicePlugin<FrameworkWiring> {
    private final InjectedValue<BundleManager> injectedBundleManager = new InjectedValue();
    private final InjectedValue<FrameworkEvents> injectedFrameworkEvents = new InjectedValue();
    private final InjectedValue<LockManager> injectedLockManager = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironment = new InjectedValue();
    private final InjectedValue<XResolver> injectedResolver = new InjectedValue();

    public FrameworkWiringPlugin() {
        super(IntegrationServices.FRAMEWORK_WIRING_PLUGIN, "Framework Refresh Thread");
    }

    @Override
    protected void addServiceDependencies(ServiceBuilder<FrameworkWiring> builder) {
        super.addServiceDependencies(builder);
        builder.addDependency(Services.BUNDLE_MANAGER, BundleManager.class, this.injectedBundleManager);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, this.injectedEnvironment);
        builder.addDependency(IntegrationServices.FRAMEWORK_EVENTS_PLUGIN, FrameworkEvents.class, this.injectedFrameworkEvents);
        builder.addDependency(IntegrationServices.LOCK_MANAGER_PLUGIN, LockManager.class, this.injectedLockManager);
        builder.addDependency(Services.RESOLVER, XResolver.class, this.injectedResolver);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    protected FrameworkWiring createServiceValue(StartContext startContext) throws StartException {
        BundleManager bundleManager = (BundleManager)this.injectedBundleManager.getValue();
        FrameworkEvents events = (FrameworkEvents)this.injectedFrameworkEvents.getValue();
        XEnvironment env = (XEnvironment)this.injectedEnvironment.getValue();
        XResolver resolver = (XResolver)this.injectedResolver.getValue();
        LockManager lockManager = (LockManager)this.injectedLockManager.getValue();
        return new FrameworkWiringImpl(bundleManager, events, env, resolver, lockManager, this.getExecutorService());
    }
}

