/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.TimerService;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.cache.Cache;
import org.jboss.as.ejb3.cache.IdentifierFactory;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.StatefulObjectFactory;
import org.jboss.as.ejb3.cache.TransactionAwareObjectFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulAllowedMethodsInformation;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;

public class StatefulSessionComponent
extends SessionBeanComponent
implements StatefulObjectFactory<StatefulSessionComponentInstance>,
PassivationManager<SessionID, StatefulSessionComponentInstance>,
IdentifierFactory<SessionID> {
    public static final Object SESSION_ID_REFERENCE_KEY = new Object();
    private final Cache<SessionID, StatefulSessionComponentInstance> cache;
    private final InterceptorFactory afterBegin;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private final InterceptorFactory postActivate;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodAccessTimeouts;
    private final DefaultAccessTimeoutService defaultAccessTimeoutProvider;
    private final int currentMarshallingVersion;
    private final Map<Integer, MarshallingConfiguration> marshallingConfigurations;
    private final InterceptorFactory ejb2XRemoveMethod;
    private final Set<Object> serialiableInterceptorContextKeys;

    protected StatefulSessionComponent(StatefulSessionComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        this.afterBegin = ejbComponentCreateService.getAfterBegin();
        this.afterBeginMethod = ejbComponentCreateService.getAfterBeginMethod();
        this.afterCompletion = ejbComponentCreateService.getAfterCompletion();
        this.afterCompletionMethod = ejbComponentCreateService.getAfterCompletionMethod();
        this.beforeCompletion = ejbComponentCreateService.getBeforeCompletion();
        this.beforeCompletionMethod = ejbComponentCreateService.getBeforeCompletionMethod();
        this.prePassivate = ejbComponentCreateService.getPrePassivate();
        this.postActivate = ejbComponentCreateService.getPostActivate();
        this.methodAccessTimeouts = ejbComponentCreateService.getMethodApplicableAccessTimeouts();
        this.defaultAccessTimeoutProvider = ejbComponentCreateService.getDefaultAccessTimeoutService();
        this.ejb2XRemoveMethod = ejbComponentCreateService.getEjb2XRemoveMethod();
        this.currentMarshallingVersion = ejbComponentCreateService.getCurrentMarshallingVersion();
        this.marshallingConfigurations = ejbComponentCreateService.getMarshallingConfigurations();
        this.serialiableInterceptorContextKeys = ejbComponentCreateService.getSerializableInterceptorContextKeys();
        String beanName = ejbComponentCreateService.getComponentClass().getName();
        TransactionAwareObjectFactory<StatefulSessionComponentInstance> factory = new TransactionAwareObjectFactory<StatefulSessionComponentInstance>(this, this.getTransactionManager());
        StatefulTimeoutInfo timeout = ejbComponentCreateService.getStatefulTimeout();
        this.cache = ejbComponentCreateService.getCacheFactory().createCache(beanName, this, factory, this, timeout);
    }

    @Override
    public StatefulSessionComponentInstance createInstance() {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    public StatefulSessionComponentInstance createInstance(Object instance) {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    protected StatefulSessionComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct, InterceptorFactoryContext context) {
        return (StatefulSessionComponentInstance)super.constructComponentInstance(instance, invokePostConstruct, context);
    }

    @Override
    public void destroyInstance(StatefulSessionComponentInstance instance) {
        instance.destroy();
    }

    @Override
    public void postActivate(StatefulSessionComponentInstance instance) {
        instance.postActivate();
    }

    @Override
    public void prePassivate(StatefulSessionComponentInstance instance) {
        instance.prePassivate();
    }

    public int getCurrentMarshallingVersion() {
        return this.currentMarshallingVersion;
    }

    public MarshallingConfiguration getMarshallingConfiguration(int version) {
        MarshallingConfiguration config = this.marshallingConfigurations.get(version);
        if (config == null) {
            throw EjbMessages.MESSAGES.unsupportedMarshallingVersion(version);
        }
        return config;
    }

    protected SessionID getSessionIdOf(InterceptorContext ctx) {
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)ctx.getPrivateData(ComponentInstance.class);
        return instance.getId();
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface, InterceptorContext context) throws IllegalStateException {
        if (businessInterface == null) {
            throw EjbMessages.MESSAGES.businessInterfaceIsNull();
        }
        return this.createViewInstanceProxy(businessInterface, Collections.singletonMap(SessionID.class, this.getSessionIdOf(context)));
    }

    @Override
    public EJBLocalObject getEJBLocalObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbLocalObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.ejbLocalObjectUnavailable(this.getComponentName());
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.singletonMap(SessionID.class, this.getSessionIdOf(ctx)), this.getEjbLocalObjectViewServiceName());
    }

    @Override
    public EJBObject getEJBObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbObjectViewServiceName() == null) {
            throw EjbMessages.MESSAGES.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        ServiceController serviceController = StatefulSessionComponent.currentServiceContainer().getRequiredService(this.getEjbObjectViewServiceName());
        ComponentView view = (ComponentView)serviceController.getValue();
        String locatorAppName = this.getEarApplicationName() == null ? "" : this.getEarApplicationName();
        return (EJBObject)EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(view.getViewClass(), locatorAppName, this.getModuleName(), this.getComponentName(), this.getDistinctName(), this.getSessionIdOf(ctx), this.getCache().getStrictAffinity()));
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        throw EjbMessages.MESSAGES.timerServiceNotSupportedForSFSB(this.getComponentName());
    }

    public AccessTimeoutDetails getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeoutDetails accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeoutDetails timeout = (AccessTimeoutDetails)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (timeout != null) {
            return timeout;
        }
        return this.defaultAccessTimeoutProvider.getDefaultAccessTimeout();
    }

    protected Interceptor createInterceptor(InterceptorFactory factory, InterceptorFactoryContext context) {
        if (factory == null) {
            return null;
        }
        context.getContextData().put(Component.class, this);
        return factory.create(context);
    }

    public SessionID createSession() {
        return this.cache.create().getId();
    }

    public Cache<SessionID, StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    @Override
    public SessionID createIdentifier() {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return SessionID.createSessionID((byte[])bb.array());
    }

    protected BasicComponentInstance instantiateComponentInstance(AtomicReference<ManagedReference> instanceReference, Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, InterceptorFactoryContext interceptorContext) {
        return new StatefulSessionComponentInstance(this, instanceReference, preDestroyInterceptor, methodInterceptors, interceptorContext);
    }

    protected void componentInstanceCreated(BasicComponentInstance basicComponentInstance, InterceptorFactoryContext context) {
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)basicComponentInstance;
        HashMap<Object, Object> serializableInterceptors = new HashMap<Object, Object>();
        for (Object key : this.serialiableInterceptorContextKeys) {
            AtomicReference data = (AtomicReference)context.getContextData().get(key);
            if (data == null) continue;
            serializableInterceptors.put(key, ((ManagedReference)data.get()).getInstance());
        }
        instance.setSerializableInterceptors(serializableInterceptors);
    }

    public void removeSession(SessionID sessionId) {
        this.cache.remove(sessionId);
    }

    public InterceptorFactory getAfterBegin() {
        return this.afterBegin;
    }

    public InterceptorFactory getAfterCompletion() {
        return this.afterCompletion;
    }

    public InterceptorFactory getBeforeCompletion() {
        return this.beforeCompletion;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public InterceptorFactory getPrePassivate() {
        return this.prePassivate;
    }

    public InterceptorFactory getPostActivate() {
        return this.postActivate;
    }

    public InterceptorFactory getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethod;
    }

    @Override
    public void start() {
        this.getShutDownInterceptorFactory().start();
        super.start();
        this.cache.start();
    }

    @Override
    public void stop() {
        this.getShutDownInterceptorFactory().shutdown();
        super.stop();
        this.cache.stop();
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? StatefulAllowedMethodsInformation.INSTANCE_BMT : StatefulAllowedMethodsInformation.INSTANCE_CMT;
    }

    public Set<Object> getSerialiableInterceptorContextKeys() {
        return this.serialiableInterceptorContextKeys;
    }

    private static ServiceContainer currentServiceContainer() {
        return AccessController.doPrivileged(new PrivilegedAction<ServiceContainer>(){

            @Override
            public ServiceContainer run() {
                return CurrentServiceContainer.getServiceContainer();
            }
        });
    }
}

