/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.remote;

import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ejb3.remote.RemoteViewManagedReferenceFactory;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;

public class RemoteViewInjectionSource
extends InjectionSource {
    private final ServiceName serviceName;
    private final String appName;
    private final String moduleName;
    private final String distinctName;
    private final String beanName;
    private final String viewClass;
    private final boolean stateful;
    private final Value<ClassLoader> viewClassLoader;

    public RemoteViewInjectionSource(ServiceName serviceName, String appName, String moduleName, String distinctName, String beanName, String viewClass, boolean stateful, Value<ClassLoader> viewClassLoader) {
        this.serviceName = serviceName;
        this.appName = appName;
        this.moduleName = moduleName;
        this.distinctName = distinctName;
        this.beanName = beanName;
        this.viewClass = viewClass;
        this.stateful = stateful;
        this.viewClassLoader = viewClassLoader;
    }

    public void getResourceValue(InjectionSource.ResolutionContext resolutionContext, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        if (this.serviceName != null) {
            serviceBuilder.addDependency(this.serviceName);
        }
        RemoteViewManagedReferenceFactory factory = new RemoteViewManagedReferenceFactory(this.appName, this.moduleName, this.distinctName, this.beanName, this.viewClass, this.stateful, this.viewClassLoader);
        injector.inject((Object)factory);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RemoteViewInjectionSource that = (RemoteViewInjectionSource)((Object)o);
        if (this.stateful != that.stateful) {
            return false;
        }
        if (this.appName != null ? !this.appName.equals(that.appName) : that.appName != null) {
            return false;
        }
        if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
            return false;
        }
        if (this.distinctName != null ? !this.distinctName.equals(that.distinctName) : that.distinctName != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(that.moduleName) : that.moduleName != null) {
            return false;
        }
        return !(this.viewClass != null ? !this.viewClass.equals(that.viewClass) : that.viewClass != null);
    }

    public int hashCode() {
        int result = this.appName != null ? this.appName.hashCode() : 0;
        result = 31 * result + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result = 31 * result + (this.distinctName != null ? this.distinctName.hashCode() : 0);
        result = 31 * result + (this.beanName != null ? this.beanName.hashCode() : 0);
        result = 31 * result + (this.viewClass != null ? this.viewClass.hashCode() : 0);
        result = 31 * result + (this.stateful ? 1 : 0);
        return result;
    }
}

