/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collection;
import java.util.Collections;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.ejb3.cache.impl.factory.NonClusteredBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.impl.factory.NonClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.subsystem.FilePassivationStoreResourceDefinition;
import org.jboss.as.ejb3.subsystem.PassivationStoreAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class FilePassivationStoreAdd
extends PassivationStoreAdd {
    public FilePassivationStoreAdd(AttributeDefinition ... attributes) {
        super(attributes);
    }

    @Override
    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        NonClusteredBackingCacheEntryStoreSourceService service = new NonClusteredBackingCacheEntryStoreSourceService(name);
        NonClusteredBackingCacheEntryStoreSource source = (NonClusteredBackingCacheEntryStoreSource)service.getValue();
        ModelNode relativeToModel = FilePassivationStoreResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, operation);
        ModelNode groupsPath = FilePassivationStoreResourceDefinition.GROUPS_PATH.resolveModelAttribute(context, operation);
        ModelNode sessionsPath = FilePassivationStoreResourceDefinition.SESSIONS_PATH.resolveModelAttribute(context, operation);
        ModelNode subdirectoryCount = FilePassivationStoreResourceDefinition.SUBDIRECTORY_COUNT.resolveModelAttribute(context, operation);
        if (relativeToModel.isDefined()) {
            source.setRelativeTo(relativeToModel.asString());
        }
        if (groupsPath.isDefined()) {
            source.setGroupDirectoryName(groupsPath.asString());
        }
        if (sessionsPath.isDefined()) {
            source.setSessionDirectoryName(sessionsPath.asString());
        }
        if (subdirectoryCount.isDefined()) {
            source.setSubdirectoryCount(subdirectoryCount.asInt());
        }
        return Collections.singleton(this.installBackingCacheEntryStoreSourceService(service, context, model, verificationHandler));
    }
}

