/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.DataInput;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.remote.TransactionalProtocolOperationHandler;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolConnectionManager;
import org.jboss.as.protocol.ProtocolConnectionUtils;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FutureManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelAssociation;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.server.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;

class HostControllerConnection
extends FutureManagementChannel {
    private static final String SERVER_CHANNEL_TYPE = "server";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String userName;
    private final String serverProcessName;
    private final ProtocolConnectionManager connectionManager;
    private final ManagementChannelHandler channelHandler;
    private final int initialOperationID;
    private ProtocolConnectionConfiguration configuration;

    HostControllerConnection(String serverProcessName, String userName, int initialOperationID, ProtocolConnectionConfiguration configuration, ExecutorService executorService) {
        this.userName = userName;
        this.serverProcessName = serverProcessName;
        this.configuration = configuration;
        this.initialOperationID = initialOperationID;
        this.channelHandler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
        this.connectionManager = ProtocolConnectionManager.create((ProtocolConnectionConfiguration)configuration, (ProtocolConnectionManager.ConnectionOpenHandler)this, (ProtocolConnectionManager.ConnectTask)new ReconnectTask());
    }

    ManagementChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public Channel getChannel() throws IOException {
        Channel channel = super.getChannel();
        if (channel == null) {
            throw ProtocolMessages.MESSAGES.channelClosed();
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void openConnection(ModelController controller, ActiveOperation.CompletedCallback<ModelNode> callback) throws Exception {
        boolean ok = false;
        Connection connection = this.connectionManager.connect();
        try {
            this.channelHandler.executeRequest((ManagementRequest)new ServerRegisterRequest(), null, callback);
            this.channelHandler.addHandlerFactory((ManagementRequestHandlerFactory)new TransactionalProtocolOperationHandler(controller, (ManagementChannelAssociation)this.channelHandler));
            ok = true;
        }
        finally {
            if (!ok) {
                connection.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    synchronized boolean reConnect(URI reconnectUri, byte[] authKey) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    synchronized void started() {
        try {
            if (this.isConnected()) {
                this.channelHandler.executeRequest((ManagementRequest)new ServerStartedRequest(), null).getResult().await();
            }
        }
        catch (Exception e) {
            ServerLogger.AS_ROOT_LOGGER.debugf(e, "failed to send started notification", new Object[0]);
        }
    }

    public void connectionOpened(Connection connection) throws IOException {
        Channel channel = this.openChannel(connection, SERVER_CHANNEL_TYPE, this.configuration.getOptionMap());
        if (this.setChannel(channel)) {
            channel.receiveMessage(this.channelHandler.getReceiver());
            channel.addCloseHandler((CloseHandler)this.channelHandler);
        } else {
            channel.closeAsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.connectionManager.shutdown();
        }
        finally {
            super.close();
        }
    }

    static CallbackHandler createClientCallbackHandler(String userName, byte[] authKey) {
        return new ClientCallbackHandler(userName, authKey);
    }

    private static class ClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final byte[] authKey;

        private ClientCallbackHandler(String userName, byte[] authKey) {
            this.userName = userName;
            this.authKey = authKey;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                    continue;
                }
                if (current instanceof RealmChoiceCallback) {
                    throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                }
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.userName);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(new String(this.authKey, UTF_8).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }

    private class ReconnectTask
    implements ProtocolConnectionManager.ConnectTask {
        private ReconnectTask() {
        }

        public Connection connect() throws IOException {
            return ProtocolConnectionUtils.connectSync((ProtocolConnectionConfiguration)HostControllerConnection.this.configuration);
        }

        public ProtocolConnectionManager.ConnectionOpenHandler getConnectionOpenedHandler() {
            return HostControllerConnection.this;
        }

        public ProtocolConnectionManager.ConnectTask connectionClosed() {
            return this;
        }

        public void shutdown() {
        }
    }

    public class ServerStartedRequest
    extends AbstractManagementRequest<Void, Void> {
        private final String message = "";

        public byte getOperationType() {
            return 2;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(33);
            output.writeUTF("");
            resultHandler.done(null);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
        }
    }

    public class ServerReconnectRequest
    extends AbstractManagementRequest<Boolean, Void> {
        public byte getOperationType() {
            return 3;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Boolean> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(1);
            output.writeUTF(HostControllerConnection.this.serverProcessName);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Boolean> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final byte param = input.readByte();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    if (param == 33) {
                        resultHandler.done((Object)Boolean.TRUE);
                    } else {
                        resultHandler.done((Object)Boolean.FALSE);
                    }
                }
            });
        }
    }

    private class ServerRegisterRequest
    extends AbstractManagementRequest<ModelNode, Void> {
        private ServerRegisterRequest() {
        }

        public byte getOperationType() {
            return 0;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.writeUTF(HostControllerConnection.this.serverProcessName);
            output.writeInt(HostControllerConnection.this.initialOperationID);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            byte param = input.readByte();
            if (param == 33) {
                ModelNode operations = new ModelNode();
                operations.readExternal(input);
                resultHandler.done((Object)operations);
            } else {
                resultHandler.failed((Exception)new IOException());
            }
        }
    }
}

