/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.OSGiMessages;
import org.jboss.as.osgi.service.BundleLifecycleIntegration;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.spi.BundleInfo;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public class OSGiBundleInfoParseProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        String runtimeName = depUnit.getName();
        if (BundleLifecycleIntegration.getDeployment(runtimeName) != null) {
            return;
        }
        OSGiMetaData metadata = (OSGiMetaData)depUnit.getAttachment(OSGiConstants.OSGI_METADATA_KEY);
        OSGiConstants.DeploymentType deploymentType = (OSGiConstants.DeploymentType)((Object)depUnit.getAttachment(OSGiConstants.DEPLOYMENT_TYPE_KEY));
        if (metadata != null && deploymentType != OSGiConstants.DeploymentType.Module) {
            try {
                org.jboss.vfs.VirtualFile virtualFile = ((ResourceRoot)depUnit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
                BundleInfo info = BundleInfo.createBundleInfo((VirtualFile)AbstractVFS.adapt((Object)virtualFile), (String)runtimeName, (OSGiMetaData)metadata);
                depUnit.putAttachment(OSGiConstants.BUNDLE_INFO_KEY, (Object)info);
            }
            catch (BundleException ex) {
                throw OSGiMessages.MESSAGES.cannotCreateBundleDeployment(ex, depUnit);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        depUnit.removeAttachment(OSGiConstants.BUNDLE_INFO_KEY);
    }
}

