/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.service;

import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import org.jboss.as.osgi.OSGiConstants;
import org.jboss.as.osgi.service.ModuleIdentityRepository;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageException;
import org.jboss.osgi.repository.RepositoryStorageFactory;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.core.FileBasedRepositoryStorage;
import org.jboss.osgi.repository.core.MavenRepository;
import org.jboss.osgi.repository.spi.AbstractPersistentRepository;
import org.jboss.osgi.repository.spi.AggregatingRepository;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class RepositoryService
extends AbstractService<XRepository> {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private ServiceRegistration<?> registration;
    private XRepository repository;

    static ServiceController<?> addService(ServiceTarget target) {
        RepositoryService service = new RepositoryService();
        ServiceBuilder builder = target.addService(OSGiConstants.REPOSITORY_SERVICE_NAME, (Service)service);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, service.injectedServerEnvironment);
        builder.addDependency(Services.FRAMEWORK_CREATE, BundleContext.class, service.injectedSystemContext);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        return builder.install();
    }

    private RepositoryService() {
    }

    public synchronized void start(StartContext startContext) throws StartException {
        final ServerEnvironment serverenv = (ServerEnvironment)this.injectedServerEnvironment.getValue();
        RepositoryStorageFactory factory = new RepositoryStorageFactory(){

            public RepositoryStorage create(XRepository repository) {
                File storageDir = new File(serverenv.getServerDataDir().getPath() + File.separator + "repository");
                return new FileBasedRepositoryStorage(repository, storageDir){

                    public XResource addResource(XResource res) throws RepositoryStorageException {
                        if (res.getCapabilities("module.identity").isEmpty()) {
                            return super.addResource(res);
                        }
                        return res;
                    }
                };
            }
        };
        final BundleContext syscontext = (BundleContext)this.injectedSystemContext.getValue();
        MavenRepository.ConfigurationPropertyProvider propProvider = new MavenRepository.ConfigurationPropertyProvider(){

            public String getProperty(String key, String defaultValue) {
                String value = syscontext.getProperty(key);
                return value != null ? value : defaultValue;
            }
        };
        AggregatingRepository aggregator = new AggregatingRepository();
        aggregator.addRepository((XRepository)new ModuleIdentityRepository(serverenv));
        aggregator.addRepository((XRepository)new MavenRepository(propProvider));
        this.repository = new AbstractPersistentRepository(factory, (XRepository)aggregator);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", this.repository.getName());
        this.registration = syscontext.registerService(XRepository.SERVICE_NAMES, (Object)this.repository, props);
    }

    public synchronized void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
        this.repository = null;
    }

    public synchronized XRepository getValue() throws IllegalStateException {
        return this.repository;
    }
}

