/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.servlet.jsp.el.FunctionMapper;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.security.SecurityUtil;

public final class ProtectedFunctionMapper
extends javax.el.FunctionMapper
implements FunctionMapper {
    private HashMap fnmap = null;
    private Method theMethod = null;

    private ProtectedFunctionMapper() {
    }

    public static ProtectedFunctionMapper getInstance() {
        ProtectedFunctionMapper funcMapper = SecurityUtil.isPackageProtectionEnabled() ? (ProtectedFunctionMapper)((Object)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new ProtectedFunctionMapper();
            }
        })) : new ProtectedFunctionMapper();
        funcMapper.fnmap = new HashMap();
        return funcMapper;
    }

    public void mapFunction(String fnQName, final Class c, final String methodName, final Class[] args) {
        Method method;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return c.getDeclaredMethod(methodName, args);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw JasperMessages.MESSAGES.invalidFunctionMapping(ex.getException().getMessage());
            }
        }
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw JasperMessages.MESSAGES.invalidFunctionMapping(e.getMessage());
        }
        this.fnmap.put(fnQName, method);
    }

    public static ProtectedFunctionMapper getMapForFunction(String fnQName, final Class c, final String methodName, final Class[] args) {
        Method method;
        ProtectedFunctionMapper funcMapper;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            funcMapper = (ProtectedFunctionMapper)((Object)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new ProtectedFunctionMapper();
                }
            }));
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return c.getDeclaredMethod(methodName, args);
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw JasperMessages.MESSAGES.invalidFunctionMapping(ex.getException().getMessage());
            }
        }
        funcMapper = new ProtectedFunctionMapper();
        try {
            method = c.getDeclaredMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            throw JasperMessages.MESSAGES.invalidFunctionMapping(e.getMessage());
        }
        funcMapper.theMethod = method;
        return funcMapper;
    }

    public Method resolveFunction(String prefix, String localName) {
        if (this.fnmap != null) {
            return (Method)this.fnmap.get(prefix + ":" + localName);
        }
        return this.theMethod;
    }
}

