/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.api.core.management.BroadcastGroupControl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.messaging.AbstractHornetQComponentControlHandler;
import org.jboss.dmr.ModelNode;

public class BroadcastGroupControlHandler
extends AbstractHornetQComponentControlHandler<BroadcastGroupControl> {
    public static final BroadcastGroupControlHandler INSTANCE = new BroadcastGroupControlHandler();

    private BroadcastGroupControlHandler() {
    }

    @Override
    protected BroadcastGroupControl getHornetQComponentControl(HornetQServer hqServer, PathAddress address) {
        String resourceName = address.getLastElement().getValue();
        return (BroadcastGroupControl)BroadcastGroupControl.class.cast(hqServer.getManagementService().getResource("core.broadcastgroup." + resourceName));
    }

    @Override
    protected String getDescriptionPrefix() {
        return "broadcast-group";
    }

    @Override
    protected Object handleOperation(String operationName, OperationContext context, ModelNode operation) throws OperationFailedException {
        if ("get-connector-pairs-as-json".equals(operationName)) {
            BroadcastGroupControl control = (BroadcastGroupControl)this.getHornetQComponentControl(context, operation, false);
            try {
                context.getResult().set(control.getConnectorPairsAsJSON());
            }
            catch (Exception e) {
                context.getFailureDescription().set(e.getLocalizedMessage());
            }
        } else {
            this.unsupportedOperation(operationName);
        }
        return null;
    }
}

