/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.List;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HornetQActivationService;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.QueueDefinition;
import org.jboss.as.messaging.QueueService;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public class QueueAdd
extends AbstractAddStepHandler {
    public static final QueueAdd INSTANCE = new QueueAdd();

    private QueueAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (SimpleAttributeDefinition attributeDefinition : QueueDefinition.ATTRIBUTES) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceName hqServiceName;
        ServiceRegistry registry = context.getServiceRegistry(true);
        ServiceController hqService = registry.getService(hqServiceName = MessagingServices.getHornetQServiceName(PathAddress.pathAddress((ModelNode)operation.get("address"))));
        if (hqService != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String queueName = address.getLastElement().getValue();
            CoreQueueConfiguration queueConfiguration = QueueAdd.createCoreQueueConfiguration(context, queueName, model);
            QueueService service = new QueueService(queueConfiguration, false);
            ServiceName queueServiceName = MessagingServices.getQueueBaseServiceName(hqServiceName).append(new String[]{queueName});
            newControllers.add(context.getServiceTarget().addService(queueServiceName, (Service)service).addDependency(HornetQActivationService.getHornetQActivationServiceName(hqServiceName)).addDependency(hqServiceName, HornetQServer.class, service.getHornetQService()).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.PASSIVE).install());
        }
    }

    static void addQueueConfigs(OperationContext context, Configuration configuration, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("queue")) {
            List configs = configuration.getQueueConfigurations();
            for (Property prop : model.get("queue").asPropertyList()) {
                configs.add(QueueAdd.createCoreQueueConfiguration(context, prop.getName(), prop.getValue()));
            }
        }
    }

    private static CoreQueueConfiguration createCoreQueueConfiguration(OperationContext context, String name, ModelNode model) throws OperationFailedException {
        String queueAddress = QueueDefinition.ADDRESS.resolveModelAttribute(context, model).asString();
        ModelNode filterNode = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        String filter = filterNode.isDefined() ? filterNode.asString() : null;
        boolean durable = CommonAttributes.DURABLE.resolveModelAttribute(context, model).asBoolean();
        return new CoreQueueConfiguration(queueAddress, name, filter, durable);
    }
}

