/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.container;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import org.jboss.as.jpa.JpaLogger;
import org.jboss.as.jpa.container.ThreadLocalStack;

public class NonTxEmCloser {
    public static final ThreadLocalStack<Map<String, EntityManager>> nonTxStack = new ThreadLocalStack();

    public static void pushCall() {
        nonTxStack.push(null);
    }

    public static void popCall() {
        Map<String, EntityManager> emStack = nonTxStack.pop();
        if (emStack != null) {
            for (EntityManager entityManager : emStack.values()) {
                try {
                    entityManager.close();
                }
                catch (RuntimeException safeToIgnore) {
                    if (!JpaLogger.ROOT_LOGGER.isTraceEnabled()) continue;
                    JpaLogger.ROOT_LOGGER.trace((Object)"Could not close (non-transactional) container managed entity manager.  This shouldn't impact application functionality (only read operations occur in non-transactional mode)", (Throwable)safeToIgnore);
                }
            }
        }
    }

    public static EntityManager get(String puScopedName) {
        Map<String, EntityManager> map = nonTxStack.get();
        if (map != null) {
            return map.get(puScopedName);
        }
        return null;
    }

    public static void add(String puScopedName, EntityManager entityManager) {
        Map<String, EntityManager> map = nonTxStack.get();
        if (map == null && nonTxStack.getList() != null) {
            map = new HashMap<String, EntityManager>();
            nonTxStack.replace(map);
        }
        if (map != null) {
            map.put(puScopedName, entityManager);
        }
    }
}

