/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.validator;

import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.cfg.ConstraintMapping;
import org.wildfly.security.manager.WildFlySecurityManager;

public class JPALazyValidatorFactory
implements ValidatorFactory {
    private volatile ValidatorFactory delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory getDelegate() {
        ValidatorFactory result = this.delegate;
        if (result == null) {
            JPALazyValidatorFactory jPALazyValidatorFactory = this;
            synchronized (jPALazyValidatorFactory) {
                result = this.delegate;
                if (result == null) {
                    this.delegate = result = this.initFactory();
                }
            }
        }
        return result;
    }

    public Validator getValidator() {
        return this.getDelegate().getValidator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidatorFactory initFactory() {
        ClassLoader oldTCCL = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            ValidatorFactory factory;
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
            ConstraintMapping mapping = new ConstraintMapping();
            HibernateValidatorConfiguration config = (HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).providerResolver((ValidationProviderResolver)new JbossProviderResolver()).configure();
            config.addMapping(mapping);
            ValidatorFactory validatorFactory = factory = config.buildValidatorFactory();
            return validatorFactory;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTCCL);
        }
    }

    public ValidatorContext usingContext() {
        return this.getDelegate().usingContext();
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.getDelegate().getMessageInterpolator();
    }

    public TraversableResolver getTraversableResolver() {
        return this.getDelegate().getTraversableResolver();
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.getDelegate().getConstraintValidatorFactory();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.getDelegate().unwrap(clazz);
    }

    private static final class JbossProviderResolver
    implements ValidationProviderResolver {
        private JbossProviderResolver() {
        }

        public List<ValidationProvider<?>> getValidationProviders() {
            return Collections.singletonList(new HibernateValidator());
        }
    }
}

