/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.parser.jboss;

import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.LoaderRepositoryConfigMetaData;
import org.jboss.metadata.common.jboss.LoaderRepositoryMetaData;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.jboss.ServiceModuleMetaData;
import org.jboss.metadata.ear.spec.EarEnvironmentRefsGroupMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.metadata.ear.spec.ModulesMetaData;
import org.jboss.metadata.ear.spec.WebModuleMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.parser.ee.SecurityRoleMetaDataParser;
import org.jboss.metadata.parser.jboss.Attribute;
import org.jboss.metadata.parser.jboss.Element;
import org.jboss.metadata.parser.jboss.Namespace;
import org.jboss.metadata.parser.jboss.Version;
import org.jboss.metadata.parser.spec.EarMetaDataParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jboss.metadata.property.PropertyReplacers;

public class JBossAppMetaDataParser
extends EarMetaDataParser {
    private static final Logger logger = Logger.getLogger(JBossAppMetaDataParser.class);
    public static final JBossAppMetaDataParser INSTANCE = new JBossAppMetaDataParser();

    @Override
    public JBossAppMetaData parse(XMLStreamReader reader) throws XMLStreamException {
        return this.parse(reader, PropertyReplacers.noop());
    }

    @Override
    public JBossAppMetaData parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        EarMetaDataParser earMetaDataParser = new EarMetaDataParser();
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = JBossAppMetaDataParser.readDTDLocation((XMLStreamReader)reader)) == null) continue;
            version = Version.forLocation(dtdLocation);
        }
        String schemaLocation = JBossAppMetaDataParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Version.forLocation(schemaLocation);
        }
        if (version == null || Version.UNKNOWN.equals((Object)version)) {
            version = Version.APP_7_0;
        }
        JBossAppMetaData appMetaData = new JBossAppMetaData();
        int count = reader.getAttributeCount();
        block16: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossAppMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    appMetaData.setId(value);
                    continue block16;
                }
                case VERSION: {
                    continue block16;
                }
                default: {
                    throw JBossAppMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        EarEnvironmentRefsGroupMetaData environmentRefsGroupMetaData = new EarEnvironmentRefsGroupMetaData();
        appMetaData.setDescriptionGroup(new DescriptionGroupMetaData());
        appMetaData.setModules(new ModulesMetaData());
        appMetaData.setSecurityRoles(new SecurityRolesMetaData());
        environmentRefsGroupMetaData.setMessageDestinations(new MessageDestinationsMetaData());
        appMetaData.setEarEnvironmentRefsGroup(environmentRefsGroupMetaData);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
            if (namespace == Namespace.SPEC || namespace == Namespace.SPEC_7_0) {
                super.handleElement(reader, appMetaData, propertyReplacer);
                continue;
            }
            switch (element) {
                case DISTINCT_NAME: {
                    String val = JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer);
                    appMetaData.setDistinctName(val);
                    continue block17;
                }
                case MODULE_ORDER: {
                    logger.warn((Object)"module-order element in jboss-app.xml is deprecated and has been ignored");
                    continue block17;
                }
                case SECURITY_DOMAIN: {
                    appMetaData.setSecurityDomain(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case UNAUTHENTICATED_PRINCIPAL: {
                    appMetaData.setUnauthenticatedPrincipal(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case JMX_NAME: {
                    logger.warn((Object)"jmx-name element in jboss-app.xml is deprecated and has been ignored");
                    continue block17;
                }
                case LIBRARY_DIRECTORY: {
                    appMetaData.setLibraryDirectory(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
                case LOADER_REPOSITORY: {
                    JBossAppMetaDataParser.parseLoaderRepository(reader, propertyReplacer);
                    logger.warn((Object)"loader-repository element in jboss-app.xml is deprecated and has been ignored");
                    continue block17;
                }
                case MODULE: {
                    appMetaData.getModules().add((MappableMetaData)JBossAppMetaDataParser.parseModule(reader, propertyReplacer));
                    continue block17;
                }
                case SECURITY_ROLE: {
                    appMetaData.getSecurityRoles().add((MappableMetaData)SecurityRoleMetaDataParser.parse((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block17;
                }
            }
            throw JBossAppMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return appMetaData;
    }

    private static LoaderRepositoryMetaData parseLoaderRepository(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        LoaderRepositoryMetaData repositoryMetaData = new LoaderRepositoryMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossAppMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    repositoryMetaData.setId(value);
                    continue block7;
                }
                case LOADER_REPOSITORY_CLASS: {
                    repositoryMetaData.setLoaderRepositoryClass(value);
                }
                default: {
                    throw JBossAppMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        while (reader.hasNext() && reader.next() != 2) {
            if (reader.hasText()) {
                StringBuilder builder = new StringBuilder();
                int event = reader.getEventType();
                if (event == 4 || event == 12 || event == 6 || event == 9) {
                    builder.append(reader.getText());
                } else if (event != 3 && event != 5) {
                    if (event == 8) {
                        throw new XMLStreamException("Unexpected end of document when reading element text content", reader.getLocation());
                    }
                    if (event == 1) {
                        throw new XMLStreamException("Element text content may not contain START_ELEMENT", reader.getLocation());
                    }
                    throw new XMLStreamException("Unexpected event type " + event, reader.getLocation());
                }
                repositoryMetaData.setName(builder.toString());
                continue;
            }
            if (reader.isStartElement()) {
                HashSet<LoaderRepositoryConfigMetaData> loaderConfigs = new HashSet<LoaderRepositoryConfigMetaData>();
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case LOADER_REPOSITORY_CONFIG: {
                        loaderConfigs.add(JBossAppMetaDataParser.parseLoaderRepositoryConfig(reader, propertyReplacer));
                    }
                }
                repositoryMetaData.setLoaderRepositoryConfig(loaderConfigs);
                continue;
            }
            throw JBossAppMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return repositoryMetaData;
    }

    private static LoaderRepositoryConfigMetaData parseLoaderRepositoryConfig(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        LoaderRepositoryConfigMetaData configMetaData = new LoaderRepositoryConfigMetaData();
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossAppMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    configMetaData.setId(value);
                    continue block4;
                }
                case CONFIG_PARSER_CLASS: {
                    configMetaData.setConfigParserClass(value);
                }
                default: {
                    throw JBossAppMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        configMetaData.setConfig(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
        return configMetaData;
    }

    private static ModuleMetaData parseModule(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        ModuleMetaData moduleMetaData = new ModuleMetaData();
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossAppMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    moduleMetaData.setId(value);
                    continue block8;
                }
                default: {
                    throw JBossAppMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HAR: {
                    moduleMetaData.setValue(JBossAppMetaDataParser.parseService(reader, propertyReplacer));
                    continue block9;
                }
                case SERVICE: {
                    moduleMetaData.setValue(JBossAppMetaDataParser.parseService(reader, propertyReplacer));
                    continue block9;
                }
                case WEB: {
                    moduleMetaData.setValue(JBossAppMetaDataParser.parseWeb(reader, propertyReplacer));
                    continue block9;
                }
            }
            throw JBossAppMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return moduleMetaData;
    }

    private static ServiceModuleMetaData parseService(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        ServiceModuleMetaData module = new ServiceModuleMetaData();
        module.setFileName(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
        return module;
    }

    private static WebModuleMetaData parseWeb(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        WebModuleMetaData webModuleMetaData = new WebModuleMetaData();
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String value = reader.getAttributeValue(i);
            if (JBossAppMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i)) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ID: {
                    webModuleMetaData.setId(value);
                    continue block7;
                }
                default: {
                    throw JBossAppMetaDataParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            org.jboss.metadata.parser.spec.Element element = org.jboss.metadata.parser.spec.Element.forName(reader.getLocalName());
            switch (element) {
                case CONTEXT_ROOT: {
                    webModuleMetaData.setContextRoot(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
                case WEB_URI: {
                    webModuleMetaData.setWebURI(JBossAppMetaDataParser.getElementText((XMLStreamReader)reader, (PropertyReplacer)propertyReplacer));
                    continue block8;
                }
            }
            throw JBossAppMetaDataParser.unexpectedElement((XMLStreamReader)reader);
        }
        return webModuleMetaData;
    }
}

