/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SnapshotListHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "list-snapshots";
    private static final SimpleAttributeDefinition DIRECTORY = new SimpleAttributeDefinitionBuilder("directory", ModelType.STRING).setAllowNull(false).build();
    private static final AttributeDefinition NAMES = new StringListAttributeDefinition.Builder("names").build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("list-snapshots", ControllerResolver.getResolver("snapshot")).setReplyParameters(DIRECTORY, NAMES).withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).build();
    private final ConfigurationPersister persister;

    public SnapshotListHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        try {
            ConfigurationPersister.SnapshotInfo info = this.persister.listSnapshots();
            ModelNode result = context.getResult();
            result.get("directory").set(info.getSnapshotDirectory());
            result.get("names").setEmptyList();
            for (String name : info.names()) {
                result.get("names").add(name);
            }
            context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage(), new ModelNode().set(e.getMessage()));
        }
    }
}

