/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Iterator;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ValidateAddressOperationHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "validate-address";
    public static final ValidateAddressOperationHandler INSTANCE = new ValidateAddressOperationHandler();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("validate-address", ControllerResolver.getResolver("global")).addParameter(SimpleAttributeDefinitionBuilder.create("value", ModelType.OBJECT).build()).setReplyParameters(SimpleAttributeDefinitionBuilder.create("valid", ModelType.BOOLEAN).build(), SimpleAttributeDefinitionBuilder.create("problem", ModelType.STRING).setAllowNull(true).build()).setReadOnly().build();

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource;
        ModelNode address = operation.require("value");
        PathAddress pathAddr = PathAddress.pathAddress(address);
        Resource model = resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        Iterator iterator = pathAddr.iterator();
        PathAddress current = PathAddress.EMPTY_ADDRESS;
        while (iterator.hasNext()) {
            PathElement next = (PathElement)iterator.next();
            current = current.append(next);
            ImmutableManagementResourceRegistration registration = context.getResourceRegistration().getSubModel(current);
            if (registration != null && registration.isRemote()) {
                if (!iterator.hasNext()) break;
                PathAddress newAddress = pathAddr.subAddress(current.size());
                ModelNode newOperation = operation.clone();
                newOperation.get("address").set(current.toModelNode());
                newOperation.get("value").set(newAddress.toModelNode());
                OperationStepHandler proxyHandler = registration.getOperationHandler(PathAddress.EMPTY_ADDRESS, OPERATION_NAME);
                if (proxyHandler == null) continue;
                context.addStep(newOperation, proxyHandler, OperationContext.Stage.MODEL, true);
                context.stepCompleted();
                return;
            }
            if (model.hasChild(next)) {
                model = model.getChild(next);
                continue;
            }
            context.getResult().get("valid").set(false);
            context.getResult().get("problem").set(ControllerMessages.MESSAGES.childResourceNotFound(next));
            context.stepCompleted();
            return;
        }
        context.getResult().get("valid").set(true);
        context.stepCompleted();
    }
}

