/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.HornetQClientMessageBundle;
import org.hornetq.core.client.impl.ClientProducerCredits;
import org.hornetq.core.client.impl.ClientProducerInternal;
import org.hornetq.core.client.impl.ClientSessionInternal;
import org.hornetq.core.message.BodyEncoder;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.core.Channel;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendContinuationMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendLargeMessage;
import org.hornetq.core.protocol.core.impl.wireformat.SessionSendMessage;
import org.hornetq.utils.DeflaterReader;
import org.hornetq.utils.HornetQBufferInputStream;
import org.hornetq.utils.TokenBucketLimiter;
import org.hornetq.utils.UUIDGenerator;

public class ClientProducerImpl
implements ClientProducerInternal {
    private final SimpleString address;
    private final ClientSessionInternal session;
    private final Channel channel;
    private volatile boolean closed;
    private final TokenBucketLimiter rateLimiter;
    private final boolean blockOnNonDurableSend;
    private final boolean blockOnDurableSend;
    private final SimpleString groupID;
    private final int minLargeMessageSize;
    private final ClientProducerCredits credits;

    public ClientProducerImpl(ClientSessionInternal session, SimpleString address, TokenBucketLimiter rateLimiter, boolean blockOnNonDurableSend, boolean blockOnDurableSend, boolean autoGroup, SimpleString groupID, int minLargeMessageSize, Channel channel) {
        this.channel = channel;
        this.session = session;
        this.address = address;
        this.rateLimiter = rateLimiter;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        this.blockOnDurableSend = blockOnDurableSend;
        this.groupID = autoGroup ? UUIDGenerator.getInstance().generateSimpleStringUUID() : groupID;
        this.minLargeMessageSize = minLargeMessageSize;
        this.credits = address != null ? session.getCredits(address, false) : null;
    }

    @Override
    public SimpleString getAddress() {
        return this.address;
    }

    @Override
    public void send(Message msg) throws HornetQException {
        this.checkClosed();
        this.doSend(null, msg);
    }

    @Override
    public void send(SimpleString address, Message msg) throws HornetQException {
        this.checkClosed();
        this.doSend(address, msg);
    }

    @Override
    public void send(String address, Message message) throws HornetQException {
        this.send(SimpleString.toSimpleString(address), message);
    }

    @Override
    public synchronized void close() throws HornetQException {
        if (this.closed) {
            return;
        }
        this.doCleanup();
    }

    @Override
    public void cleanUp() {
        if (this.closed) {
            return;
        }
        this.doCleanup();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isBlockOnDurableSend() {
        return this.blockOnDurableSend;
    }

    @Override
    public boolean isBlockOnNonDurableSend() {
        return this.blockOnNonDurableSend;
    }

    @Override
    public int getMaxRate() {
        return this.rateLimiter == null ? -1 : this.rateLimiter.getRate();
    }

    @Override
    public ClientProducerCredits getProducerCredits() {
        return this.credits;
    }

    private void doCleanup() {
        if (this.address != null) {
            this.session.returnCredits(this.address);
        }
        this.session.removeProducer(this);
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(SimpleString address, Message msg) throws HornetQException {
        this.session.startCall();
        try {
            ClientProducerCredits theCredits;
            MessageInternal msgI = (MessageInternal)msg;
            boolean isLarge = msgI.getBodyInputStream() != null || msgI.isLargeMessage() || msgI.getBodyBuffer().writerIndex() > this.minLargeMessageSize && !msgI.isServerMessage();
            if (address != null) {
                if (!isLarge) {
                    this.session.setAddress(msg, address);
                } else {
                    msg.setAddress(address);
                }
                theCredits = this.session.getCredits(address, true);
            } else {
                if (!isLarge) {
                    this.session.setAddress(msg, this.address);
                } else {
                    msg.setAddress(this.address);
                }
                theCredits = this.credits;
            }
            if (this.rateLimiter != null) {
                this.rateLimiter.limit();
            }
            if (this.groupID != null) {
                msgI.putStringProperty(Message.HDR_GROUP_ID, this.groupID);
            }
            boolean sendBlocking = msgI.isDurable() ? this.blockOnDurableSend : this.blockOnNonDurableSend;
            this.session.workDone();
            if (isLarge) {
                this.largeMessageSend(sendBlocking, msgI, theCredits);
            } else {
                this.sendRegularMessage(msgI, sendBlocking, theCredits);
            }
        }
        finally {
            this.session.endCall();
        }
    }

    private void sendRegularMessage(MessageInternal msgI, boolean sendBlocking, ClientProducerCredits theCredits) throws HornetQException {
        try {
            theCredits.acquireCredits(msgI.getEncodeSize());
        }
        catch (InterruptedException e) {
            throw new HornetQInterruptedException(e);
        }
        SessionSendMessage packet = new SessionSendMessage(msgI, sendBlocking);
        if (sendBlocking) {
            this.channel.sendBlocking(packet, (byte)21);
        } else {
            this.channel.sendBatched(packet);
        }
    }

    private void checkClosed() throws HornetQException {
        if (this.closed) {
            throw HornetQClientMessageBundle.BUNDLE.producerClosed();
        }
    }

    private void largeMessageSend(boolean sendBlocking, MessageInternal msgI, ClientProducerCredits credits) throws HornetQException {
        int headerSize = msgI.getHeadersAndPropertiesEncodeSize();
        if (msgI.getHeadersAndPropertiesEncodeSize() >= this.minLargeMessageSize) {
            throw HornetQClientMessageBundle.BUNDLE.headerSizeTooBig(headerSize);
        }
        if (msgI.getBodyInputStream() == null && msgI.getWholeBuffer() != null) {
            msgI.getWholeBuffer().readerIndex(0);
        }
        if (msgI.isServerMessage()) {
            this.largeMessageSendServer(sendBlocking, msgI, credits);
        } else {
            InputStream input = msgI.getBodyInputStream();
            if (input != null) {
                this.largeMessageSendStreamed(sendBlocking, msgI, input, credits);
            } else {
                this.largeMessageSendBuffered(sendBlocking, msgI, credits);
            }
        }
    }

    private void sendInitialLargeMessageHeader(MessageInternal msgI, ClientProducerCredits credits) throws HornetQException {
        SessionSendLargeMessage initialChunk = new SessionSendLargeMessage(msgI);
        this.channel.send(initialChunk);
        try {
            credits.acquireCredits(msgI.getHeadersAndPropertiesEncodeSize());
        }
        catch (InterruptedException e) {
            throw new HornetQInterruptedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void largeMessageSendServer(boolean sendBlocking, MessageInternal msgI, ClientProducerCredits credits) throws HornetQException {
        this.sendInitialLargeMessageHeader(msgI, credits);
        BodyEncoder context = msgI.getBodyEncoder();
        long bodySize = context.getLargeBodySize();
        context.open();
        try {
            int pos = 0;
            while ((long)pos < bodySize) {
                int chunkLength = Math.min((int)(bodySize - (long)pos), this.minLargeMessageSize);
                HornetQBuffer bodyBuffer = HornetQBuffers.fixedBuffer(chunkLength);
                context.encode(bodyBuffer, chunkLength);
                boolean lastChunk = (long)(pos += chunkLength) >= bodySize;
                SessionSendContinuationMessage chunk = new SessionSendContinuationMessage(msgI, bodyBuffer.toByteBuffer().array(), !lastChunk, lastChunk && sendBlocking);
                if (sendBlocking && lastChunk) {
                    this.channel.sendBlocking(chunk, (byte)21);
                } else {
                    this.channel.send(chunk);
                }
                try {
                    credits.acquireCredits(chunk.getPacketSize());
                }
                catch (InterruptedException e) {
                    throw new HornetQInterruptedException(e);
                    return;
                }
            }
        }
        finally {
            context.close();
        }
    }

    private void largeMessageSendBuffered(boolean sendBlocking, MessageInternal msgI, ClientProducerCredits credits) throws HornetQException {
        msgI.getBodyBuffer().readerIndex(0);
        this.largeMessageSendStreamed(sendBlocking, msgI, new HornetQBufferInputStream(msgI.getBodyBuffer()), credits);
    }

    private void largeMessageSendStreamed(boolean sendBlocking, MessageInternal msgI, InputStream inputStreamParameter, ClientProducerCredits credits) throws HornetQException {
        boolean lastPacket = false;
        InputStream input = inputStreamParameter;
        AtomicLong messageSize = new AtomicLong();
        DeflaterReader deflaterReader = null;
        if (this.session.isCompressLargeMessages()) {
            msgI.putBooleanProperty(Message.HDR_LARGE_COMPRESSED, true);
            deflaterReader = new DeflaterReader(inputStreamParameter, messageSize);
            input = deflaterReader;
        }
        long totalSize = 0L;
        boolean headerSent = false;
        while (!lastPacket) {
            SessionSendContinuationMessage chunk;
            int numberOfBytesRead;
            byte[] buff = new byte[this.minLargeMessageSize];
            int pos = 0;
            do {
                int wanted = this.minLargeMessageSize - pos;
                try {
                    numberOfBytesRead = input.read(buff, pos, wanted);
                }
                catch (IOException e) {
                    throw HornetQClientMessageBundle.BUNDLE.errorReadingBody(e);
                }
                if (numberOfBytesRead != -1) continue;
                lastPacket = true;
                break;
            } while ((pos += numberOfBytesRead) < this.minLargeMessageSize);
            totalSize += (long)pos;
            if (lastPacket) {
                if (!this.session.isCompressLargeMessages()) {
                    messageSize.set(totalSize);
                }
                byte[] buff2 = new byte[pos];
                System.arraycopy(buff, 0, buff2, 0, pos);
                buff = buff2;
                if (!headerSent && this.session.isCompressLargeMessages() && buff2.length < this.minLargeMessageSize) {
                    msgI.getBodyBuffer().resetReaderIndex();
                    msgI.getBodyBuffer().resetWriterIndex();
                    msgI.putLongProperty(Message.HDR_LARGE_BODY_SIZE, deflaterReader.getTotalSize());
                    msgI.getBodyBuffer().writeBytes(buff, 0, pos);
                    this.sendRegularMessage(msgI, sendBlocking, credits);
                    return;
                }
                chunk = new SessionSendContinuationMessage(msgI, buff, false, sendBlocking, messageSize.get());
            } else {
                chunk = new SessionSendContinuationMessage(msgI, buff, true, false);
            }
            if (!headerSent) {
                this.sendInitialLargeMessageHeader(msgI, credits);
                headerSent = true;
            }
            if (sendBlocking && lastPacket) {
                this.channel.sendBlocking(chunk, (byte)21);
            } else {
                this.channel.send(chunk);
            }
            try {
                credits.acquireCredits(chunk.getPacketSize());
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException(e);
            }
        }
        try {
            input.close();
        }
        catch (IOException e) {
            throw HornetQClientMessageBundle.BUNDLE.errorClosingLargeMessage(e);
        }
    }
}

