/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.remoting.impl.netty;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQInterruptedException;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.buffers.impl.ChannelBufferWrapper;
import org.hornetq.core.client.HornetQClientLogger;
import org.hornetq.core.remoting.impl.netty.NettyConnectorFactory;
import org.hornetq.core.security.HornetQPrincipal;
import org.hornetq.spi.core.remoting.Connection;
import org.hornetq.spi.core.remoting.ConnectionLifeCycleListener;
import org.hornetq.spi.core.remoting.ReadyListener;
import org.hornetq.utils.ConcurrentHashSet;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.handler.ssl.SslHandler;

public class NettyConnection
implements Connection {
    private static final int BATCHING_BUFFER_SIZE = 8192;
    private final Channel channel;
    private boolean closed;
    private final ConnectionLifeCycleListener listener;
    private final boolean batchingEnabled;
    private final boolean directDeliver;
    private volatile HornetQBuffer batchBuffer;
    private final Map<String, Object> configuration;
    private final Semaphore writeLock = new Semaphore(1);
    private final Set<ReadyListener> readyListeners = new ConcurrentHashSet<ReadyListener>();

    public NettyConnection(Map<String, Object> configuration, Channel channel, ConnectionLifeCycleListener listener, boolean batchingEnabled, boolean directDeliver) {
        this.configuration = configuration;
        this.channel = channel;
        this.listener = listener;
        this.batchingEnabled = batchingEnabled;
        this.directDeliver = directDeliver;
    }

    @Override
    public synchronized void close() {
        ChannelFuture closeFuture;
        if (this.closed) {
            return;
        }
        SslHandler sslHandler = (SslHandler)this.channel.getPipeline().get("ssl");
        if (sslHandler != null) {
            try {
                ChannelFuture sslCloseFuture = sslHandler.close();
                if (!sslCloseFuture.awaitUninterruptibly(10000L)) {
                    HornetQClientLogger.LOGGER.timeoutClosingSSL();
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (!(closeFuture = this.channel.close()).awaitUninterruptibly(10000L)) {
            HornetQClientLogger.LOGGER.timeoutClosingNettyChannel();
        }
        this.closed = true;
        this.listener.connectionDestroyed(this.getID());
    }

    @Override
    public HornetQBuffer createBuffer(int size) {
        return new ChannelBufferWrapper(ChannelBuffers.dynamicBuffer(size));
    }

    @Override
    public Object getID() {
        return this.channel.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkFlushBatchBuffer() {
        if (!this.batchingEnabled) {
            return;
        }
        if (this.writeLock.tryAcquire()) {
            try {
                if (this.batchBuffer != null && this.batchBuffer.readable()) {
                    this.channel.write(this.batchBuffer.channelBuffer());
                    this.batchBuffer = HornetQBuffers.dynamicBuffer(8192);
                }
            }
            finally {
                this.writeLock.release();
            }
        }
    }

    @Override
    public void write(HornetQBuffer buffer) {
        this.write(buffer, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(HornetQBuffer buffer, boolean flush, boolean batched) {
        block12: {
            try {
                this.writeLock.acquire();
                try {
                    if (this.batchBuffer == null && this.batchingEnabled && batched && !flush) {
                        this.batchBuffer = HornetQBuffers.dynamicBuffer(8192);
                    }
                    if (this.batchBuffer != null) {
                        this.batchBuffer.writeBytes(buffer, 0, buffer.writerIndex());
                        if (this.batchBuffer.writerIndex() < 8192 && batched && !flush) {
                            return;
                        }
                        buffer = this.batchBuffer;
                        this.batchBuffer = !batched || flush ? null : HornetQBuffers.dynamicBuffer(8192);
                    }
                    ChannelFuture future = this.channel.write(buffer.channelBuffer());
                    if (!flush) break block12;
                    try {
                        boolean ok = future.await(10000L);
                        if (!ok) {
                            HornetQClientLogger.LOGGER.timeoutFlushingPacket();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new HornetQInterruptedException(e);
                    }
                }
                finally {
                    this.writeLock.release();
                }
            }
            catch (InterruptedException e) {
                throw new HornetQInterruptedException(e);
            }
        }
    }

    @Override
    public String getRemoteAddress() {
        return this.channel.getRemoteAddress().toString();
    }

    public boolean isDirectDeliver() {
        return this.directDeliver;
    }

    @Override
    public void addReadyListener(ReadyListener listener) {
        this.readyListeners.add(listener);
    }

    @Override
    public void removeReadyListener(ReadyListener listener) {
        this.readyListeners.remove(listener);
    }

    @Override
    public HornetQPrincipal getDefaultHornetQPrincipal() {
        return null;
    }

    void fireReady(boolean ready) {
        for (ReadyListener listener : this.readyListeners) {
            listener.readyForWriting(ready);
        }
    }

    @Override
    public TransportConfiguration getConnectorConfig() {
        if (this.configuration != null) {
            return new TransportConfiguration(NettyConnectorFactory.class.getName(), this.configuration);
        }
        return null;
    }

    public String toString() {
        return super.toString() + "[local= " + this.channel.getLocalAddress() + ", remote=" + this.channel.getRemoteAddress() + "]";
    }
}

