/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remotingjmx.protocol.v2;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.remote.JMXServiceURL;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Channel;
import org.jboss.remotingjmx.VersionedConnection;
import org.jboss.remotingjmx.protocol.v2.ClientCommon;
import org.jboss.remotingjmx.protocol.v2.ClientConnection;
import org.jboss.remotingjmx.protocol.v2.ClientExecutorManager;
import org.jboss.remotingjmx.protocol.v2.ClientRequestManager;
import org.jboss.remotingjmx.protocol.v2.Common;
import org.jboss.remotingjmx.protocol.v2.VersionTwo;
import org.jboss.remotingjmx.protocol.v2.VersionedIoFuture;
import org.jboss.remotingjmx.protocol.v2.WelcomeMessageReceiver;
import org.xnio.IoFuture;

public class ParameterConnection
extends ClientCommon {
    private static final Logger log = Logger.getLogger(ParameterConnection.class);
    private final Channel channel;
    private final Map<String, ?> environment;
    private final ClientRequestManager clientRequestManager;
    private final ClientExecutorManager clientExecutorManager;
    private final JMXServiceURL serviceUrl;
    private final Map<Byte, Common.MessageHandler> handlerRegistry;

    ParameterConnection(Channel channel, Map<String, ?> environment, JMXServiceURL serviceUrl) {
        super(channel, environment);
        this.channel = channel;
        this.environment = environment;
        this.clientRequestManager = new ClientRequestManager();
        this.clientExecutorManager = new ClientExecutorManager(environment);
        this.serviceUrl = serviceUrl;
        this.handlerRegistry = this.createHandlerRegistry();
    }

    private Map<Byte, Common.MessageHandler> createHandlerRegistry() {
        HashMap<Byte, ClientCommon.BaseResponseHandler> registry = new HashMap<Byte, ClientCommon.BaseResponseHandler>();
        registry.put((byte)-16, new ClientCommon.MarshalledResponseHandler(0));
        registry.put((byte)-15, new BeginResponseHandler());
        return Collections.unmodifiableMap(registry);
    }

    @Override
    Map<Byte, Common.MessageHandler> getHandlerRegistry() {
        return this.handlerRegistry;
    }

    @Override
    protected ClientRequestManager getClientRequestManager() {
        return this.clientRequestManager;
    }

    @Override
    protected ClientExecutorManager getClientExecutorManager() {
        return this.clientExecutorManager;
    }

    VersionedConnection getConnection() throws IOException {
        this.sendVersionHeader();
        IoFuture<Void> futureWelcome = WelcomeMessageReceiver.awaitWelcomeMessage(this.channel);
        IoFuture.Status result = futureWelcome.await(this.timeoutSeconds, TimeUnit.SECONDS);
        switch (result) {
            case DONE: {
                this.channel.receiveMessage(new ClientCommon.MessageReceiver());
                break;
            }
            case FAILED: {
                throw futureWelcome.getException();
            }
            default: {
                throw new IOException("Unable to obtain connectionId, status=" + result.toString());
            }
        }
        this.sendKeyPairs();
        String connectionId = this.begin();
        ClientConnection cc = new ClientConnection(this.channel, this.environment, this.clientRequestManager, this.clientExecutorManager, connectionId);
        cc.start();
        return cc;
    }

    private void sendKeyPairs() throws IOException {
        String path = this.serviceUrl.getURLPath();
        if (path.contains("?")) {
            String[] pairs;
            String parameters = path.substring(path.indexOf("?") + 1);
            for (String currentPair : pairs = parameters.split(",")) {
                String[] keyValue = currentPair.split("=");
                if (keyValue.length != 2) {
                    throw new IOException(String.format("Unable to parse key pairs from '%s'", parameters));
                }
                this.setKeyPair(keyValue[0], keyValue[1]);
            }
        }
    }

    private void sendVersionHeader() throws IOException {
        this.write(new Common.MessageWriter(){

            @Override
            public void write(DataOutput output) throws IOException {
                output.writeBytes("JMX");
                output.writeByte(VersionTwo.getVersionIdentifier());
            }
        });
    }

    private void setKeyPair(final String key, final String value) throws IOException {
        VersionedIoFuture future = new VersionedIoFuture();
        final int correlationId = this.clientRequestManager.reserveNextCorrelationId(future);
        try {
            this.write(new Common.MessageWriter(){

                @Override
                public void write(DataOutput output) throws IOException {
                    output.writeByte(112);
                    output.writeInt(correlationId);
                    output.writeByte(8);
                    output.writeUTF(key);
                    output.writeByte(8);
                    output.writeUTF(value);
                }
            });
            log.tracef("[%d] unregisterMBean - Request Sent", (Object)correlationId);
            IoFuture.Status result = future.await(this.timeoutSeconds, TimeUnit.SECONDS);
            switch (result) {
                case FAILED: {
                    throw future.getException();
                }
                case DONE: {
                    ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                    if (response.e == null) {
                        return;
                    }
                    throw this.toIoException(response.e);
                }
            }
            throw new IOException("Unable to invoke unregisterMBean, status=" + result.toString());
        }
        finally {
            this.clientRequestManager.releaseCorrelationId(correlationId);
        }
    }

    private String begin() throws IOException {
        VersionedIoFuture future = new VersionedIoFuture();
        final int correlationId = this.clientRequestManager.reserveNextCorrelationId(future);
        try {
            this.write(new Common.MessageWriter(){

                @Override
                public void write(DataOutput output) throws IOException {
                    output.writeByte(113);
                    output.writeInt(correlationId);
                }
            });
            log.tracef("[%d] begin - Request Sent", (Object)correlationId);
            IoFuture.Status result = future.await(this.timeoutSeconds, TimeUnit.SECONDS);
            switch (result) {
                case FAILED: {
                    throw future.getException();
                }
                case DONE: {
                    ClientCommon.TypeExceptionHolder response = (ClientCommon.TypeExceptionHolder)future.get();
                    if (response.e == null) {
                        String string = (String)response.value;
                        return string;
                    }
                    throw this.toIoException(response.e);
                }
            }
            throw new IOException("Unable to invoke begin, status=" + result.toString());
        }
        finally {
            this.clientRequestManager.releaseCorrelationId(correlationId);
        }
    }

    private class BeginResponseHandler
    extends ClientCommon.StringResponseHandler
    implements ClientCommon.MessageHandler {
        private BeginResponseHandler() {
        }

        @Override
        public boolean endReceiveLoop() {
            return true;
        }
    }
}

