/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.entities.mapper.relation.query;

import org.hibernate.Query;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.configuration.AuditEntitiesConfiguration;
import org.hibernate.envers.entities.mapper.id.QueryParameterData;
import org.hibernate.envers.entities.mapper.relation.MiddleIdData;
import org.hibernate.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.hibernate.envers.reader.AuditReaderImplementor;

public abstract class AbstractRelationQueryGenerator
implements RelationQueryGenerator {
    protected final AuditEntitiesConfiguration verEntCfg;
    protected final MiddleIdData referencingIdData;
    protected final boolean revisionTypeInId;

    protected AbstractRelationQueryGenerator(AuditEntitiesConfiguration verEntCfg, MiddleIdData referencingIdData, boolean revisionTypeInId) {
        this.verEntCfg = verEntCfg;
        this.referencingIdData = referencingIdData;
        this.revisionTypeInId = revisionTypeInId;
    }

    protected abstract String getQueryString();

    @Override
    public Query getQuery(AuditReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.getQueryString());
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingIdData.getPrefixedMapper().mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }

    protected String getRevisionTypePath() {
        return this.revisionTypeInId ? this.verEntCfg.getOriginalIdPropName() + "." + this.verEntCfg.getRevisionTypePropName() : this.verEntCfg.getRevisionTypePropName();
    }
}

