/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria;

import org.hibernate.envers.configuration.AuditConfiguration;
import org.hibernate.envers.entities.RelationDescription;
import org.hibernate.envers.query.criteria.AuditCriterion;
import org.hibernate.envers.query.criteria.CriteriaTools;
import org.hibernate.envers.query.property.PropertyNameGetter;
import org.hibernate.envers.reader.AuditReaderImplementor;
import org.hibernate.envers.tools.query.Parameters;
import org.hibernate.envers.tools.query.QueryBuilder;

public class NullAuditExpression
implements AuditCriterion {
    private PropertyNameGetter propertyNameGetter;

    public NullAuditExpression(PropertyNameGetter propertyNameGetter) {
        this.propertyNameGetter = propertyNameGetter;
    }

    @Override
    public void addToQuery(AuditConfiguration auditCfg, AuditReaderImplementor versionsReader, String entityName, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(auditCfg, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(auditCfg, entityName, propertyName);
        if (relatedEntity == null) {
            parameters.addNullRestriction(propertyName, true);
        } else {
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, null, null, true);
        }
    }
}

