/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.distribution.ch.DefaultConsistentHashFactory;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyAwareConsistentHashFactory
extends DefaultConsistentHashFactory {
    @Override
    protected void addBackupOwners(DefaultConsistentHashFactory.Builder builder) {
        int minSegments = builder.getActualNumOwners() * builder.getNumSegments() / builder.getNumNodes();
        this.removeExtraBackupOwners(builder, minSegments);
        this.addBackupOwnersForLevel(builder, minSegments, Level.SITE);
        this.addBackupOwnersForLevel(builder, minSegments, Level.RACK);
        this.addBackupOwnersForLevel(builder, minSegments, Level.MACHINE);
        this.addBackupOwnersForLevel(builder, minSegments, Level.NONE);
        this.replaceBackupOwnersForLevel(builder, Level.SITE);
        this.replaceBackupOwnersForLevel(builder, Level.RACK);
        this.replaceBackupOwnersForLevel(builder, Level.MACHINE);
        this.replaceBackupOwnerForMachineLevel(builder, minSegments);
    }

    private void addBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int minSegments, Level level) {
        int currentMax = minSegments;
        while (this.doAddBackupOwnersForLevel(builder, currentMax, level)) {
            ++currentMax;
        }
    }

    private boolean doAddBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, int maxSegments, Level level) {
        boolean sufficientOwners = true;
        boolean modified = false;
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            for (Address candidate : builder.getMembers()) {
                if (owners.size() >= builder.getActualNumOwners()) break;
                if (builder.getOwned(candidate) >= maxSegments || owners.contains(candidate) || this.locationIsDuplicate(candidate, owners, level)) continue;
                builder.addOwner(segment, candidate);
                modified = true;
            }
            sufficientOwners &= owners.size() >= builder.getActualNumOwners();
        }
        return !sufficientOwners && modified;
    }

    protected void replaceBackupOwnersForLevel(DefaultConsistentHashFactory.Builder builder, Level level) {
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            List<Address> owners = builder.getOwners(segment);
            List<Address> backupOwners = builder.getBackupOwners(segment);
            block1: for (int i = backupOwners.size() - 1; i >= 0; --i) {
                Address owner = backupOwners.get(i);
                if (!this.locationIsDuplicate(owner, owners, level)) continue;
                for (Address candidate : builder.getMembers()) {
                    if (owners.contains(candidate) || this.locationIsDuplicate(candidate, owners, level)) continue;
                    builder.addOwner(segment, candidate);
                    builder.removeOwner(segment, owner);
                    owners = builder.getOwners(segment);
                    backupOwners = builder.getBackupOwners(segment);
                    continue block1;
                }
            }
        }
    }

    protected void replaceBackupOwnerForMachineLevel(DefaultConsistentHashFactory.Builder builder, int minSegments) {
        this.doReplaceBackupOwnersSameMachine(builder, minSegments, minSegments + 1);
        this.doReplaceBackupOwnersSameMachine(builder, minSegments, minSegments);
        this.doReplaceBackupOwnersSameMachine(builder, minSegments + 1, minSegments + 1);
    }

    private void doReplaceBackupOwnersSameMachine(DefaultConsistentHashFactory.Builder builder, int minSegments, int maxSegments) {
        for (int ownerIdx = builder.getActualNumOwners() - 1; ownerIdx >= 1; --ownerIdx) {
            block1: for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
                List<Address> owners = builder.getOwners(segment);
                Address owner = owners.get(ownerIdx);
                if (builder.getOwned(owner) <= maxSegments) continue;
                for (Address candidate : builder.getMembers()) {
                    if (builder.getOwned(candidate) >= minSegments || owners.contains(candidate) || !this.maintainsMachines(owners, candidate, owner)) continue;
                    builder.addOwner(segment, candidate);
                    builder.removeOwner(segment, owner);
                    continue block1;
                }
            }
        }
    }

    private Object getLocationId(Address address, Level level) {
        Object locationId;
        TopologyAwareAddress taa = (TopologyAwareAddress)address;
        switch (level) {
            case SITE: {
                locationId = "" + taa.getSiteId();
                break;
            }
            case RACK: {
                locationId = taa.getSiteId() + "|" + taa.getRackId();
                break;
            }
            case MACHINE: {
                locationId = taa.getSiteId() + "|" + taa.getRackId() + "|" + taa.getMachineId();
                break;
            }
            case NONE: {
                locationId = address;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown level: " + (Object)((Object)level));
            }
        }
        return locationId;
    }

    private boolean locationIsDuplicate(Address target, List<Address> addresses, Level level) {
        for (Address address : addresses) {
            if (address == target || !this.getLocationId(address, level).equals(this.getLocationId(target, level))) continue;
            return true;
        }
        return false;
    }

    private boolean maintainsMachines(List<Address> owners, Address candidate, Address replaced) {
        HashSet<Object> newMachines = new HashSet<Object>(owners.size());
        newMachines.add(this.getLocationId(candidate, Level.MACHINE));
        for (Address node : owners) {
            if (node.equals(replaced)) continue;
            newMachines.add(this.getLocationId(node, Level.MACHINE));
        }
        return newMachines.contains(this.getLocationId(replaced, Level.MACHINE));
    }

    public static class Externalizer
    extends AbstractExternalizer<TopologyAwareConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, TopologyAwareConsistentHashFactory chf) throws IOException {
        }

        @Override
        public TopologyAwareConsistentHashFactory readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            return new TopologyAwareConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 94;
        }

        @Override
        public Set<Class<? extends TopologyAwareConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(TopologyAwareConsistentHashFactory.class);
        }
    }

    private static enum Level {
        SITE,
        RACK,
        MACHINE,
        NONE;

    }
}

