/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate4.management;

import org.hibernate.stat.EntityStatistics;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.jpa.hibernate4.management.ManagementLookup;
import org.jboss.as.jpa.spi.PersistenceUnitServiceRegistry;
import org.jboss.dmr.ModelNode;

public abstract class EntityMetricsHandler
extends AbstractRuntimeOnlyHandler {
    private final PersistenceUnitServiceRegistry persistenceUnitRegistry;

    private EntityMetricsHandler(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        this.persistenceUnitRegistry = persistenceUnitRegistry;
    }

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        EntityStatistics statistics = this.entityStatistics(operation);
        if (statistics != null) {
            this.handle(statistics, context, operation.require("name").asString());
        }
        context.stepCompleted();
    }

    protected abstract void handle(EntityStatistics var1, OperationContext var2, String var3);

    private EntityStatistics entityStatistics(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String puResourceName = address.getElement(address.size() - 2).getValue();
        String entityName = address.getLastElement().getValue();
        ManagementLookup stats = ManagementLookup.create(this.persistenceUnitRegistry, puResourceName);
        return stats == null ? null : stats.getStatistics().getEntityStatistics(entityName);
    }

    static final EntityMetricsHandler getDeleteCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getDeleteCount();
                context.getResult().set(count);
            }
        };
    }

    static final EntityMetricsHandler getInsertCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getInsertCount();
                context.getResult().set(count);
            }
        };
    }

    static final EntityMetricsHandler getLoadCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getLoadCount();
                context.getResult().set(count);
            }
        };
    }

    static final EntityMetricsHandler getUpdateCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getUpdateCount();
                context.getResult().set(count);
            }
        };
    }

    static final EntityMetricsHandler getFetchCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getFetchCount();
                context.getResult().set(count);
            }
        };
    }

    static final EntityMetricsHandler getOptimisticFailureCount(PersistenceUnitServiceRegistry persistenceUnitRegistry) {
        return new EntityMetricsHandler(persistenceUnitRegistry){

            @Override
            protected void handle(EntityStatistics statistics, OperationContext context, String attributeName) {
                long count = statistics.getOptimisticFailureCount();
                context.getResult().set(count);
            }
        };
    }
}

