/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.XWiringSupport;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.jboss.osgi.resolver.spi.RemoveOnlyCollection;
import org.jboss.osgi.resolver.spi.ResolverHookProcessor;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public class AbstractEnvironment
implements XEnvironment {
    private final AtomicLong resourceIndex = new AtomicLong();
    private final Map<CacheKey, Set<Capability>> capabilityCache = new ConcurrentHashMap<CacheKey, Set<Capability>>();
    private final Map<String, Set<XResource>> resourceTypeCache = new ConcurrentHashMap<String, Set<XResource>>();
    private final Map<Long, XResource> resourceIndexCache = new ConcurrentHashMap<Long, XResource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long nextResourceIdentifier(Long value, String symbolicName) {
        AtomicLong atomicLong = this.resourceIndex;
        synchronized (atomicLong) {
            if (value != null) {
                this.resourceIndex.addAndGet(Math.max(0L, value - this.resourceIndex.get()));
                return value;
            }
            Long result = this.resourceIndex.incrementAndGet();
            ResolverLogger.LOGGER.tracef("Resource identifier for %s: [%d,%d]", symbolicName, value, result);
            return result;
        }
    }

    @Override
    public synchronized void installResources(XResource ... resources) {
        if (resources == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resources");
        }
        for (XResource res : resources) {
            XIdentityCapability icap = res.getIdentityCapability();
            if (this.getCachedCapabilities(CacheKey.create(icap)).contains(icap)) {
                throw ResolverMessages.MESSAGES.illegalStateResourceAlreadyInstalled(res);
            }
            ResolverLogger.LOGGER.debugf("Install resource: %s", res);
            Long index = this.nextResourceIdentifier((Long)res.getAttachment(XResource.RESOURCE_IDENTIFIER_KEY), icap.getSymbolicName());
            res.putAttachment(XResource.RESOURCE_IDENTIFIER_KEY, index);
            this.resourceIndexCache.put(index, res);
            this.getCachedResources(icap.getType()).add(res);
            for (Capability cap : res.getCapabilities(null)) {
                CacheKey cachekey = CacheKey.create(cap);
                this.getCachedCapabilities(cachekey).add(cap);
                ResolverLogger.LOGGER.debugf("   %s", cap);
            }
            if (ResolverLogger.LOGGER.isDebugEnabled()) {
                for (Requirement req : res.getRequirements(null)) {
                    ResolverLogger.LOGGER.debugf("   %s", req);
                }
            }
            AbstractResource absres = AbstractResource.assertAbstractResource(res);
            absres.setState(XResource.State.INSTALLED);
        }
    }

    @Override
    public synchronized void uninstallResources(XResource ... resources) {
        if (resources == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resources");
        }
        for (XResource res : resources) {
            Long index = (Long)res.getAttachment(XResource.RESOURCE_IDENTIFIER_KEY);
            if (index == null || this.resourceIndexCache.remove(index) == null) {
                ResolverLogger.LOGGER.debugf("Unknown resource: %s", res);
                continue;
            }
            ResolverLogger.LOGGER.debugf("Uninstall resource: %s", res);
            XIdentityCapability icap = res.getIdentityCapability();
            this.getCachedResources(icap.getType()).remove(res);
            for (Capability cap : res.getCapabilities(null)) {
                CacheKey cachekey = CacheKey.create(cap);
                Set<Capability> cachecaps = this.getCachedCapabilities(cachekey);
                cachecaps.remove(cap);
                if (!cachecaps.isEmpty()) continue;
                this.capabilityCache.remove(cachekey);
            }
            res.getWiringSupport().refresh();
            AbstractResource absres = AbstractResource.assertAbstractResource(res);
            absres.setState(XResource.State.UNINSTALLED);
        }
    }

    @Override
    public synchronized XResource getResourceById(long resId) {
        return this.resourceIndexCache.get(resId);
    }

    @Override
    public synchronized Collection<XResource> getResources(String ... types) {
        HashSet<XResource> result = new HashSet<XResource>();
        for (String type : types != null ? types : ALL_IDENTITY_TYPES) {
            result.addAll(this.getCachedResources(type));
        }
        return result;
    }

    @Override
    public synchronized List<Capability> findProviders(Requirement req) {
        if (req == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("req");
        }
        XRequirement xreq = (XRequirement)req;
        CacheKey cachekey = CacheKey.create(req);
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Capability cap : this.findCachedCapabilities(cachekey)) {
            if (!xreq.matches(cap)) continue;
            boolean ignoreCapability = false;
            XCapability xcap = (XCapability)cap;
            XResource capres = (XResource)xcap.getResource();
            XWiringSupport wiringSupport = capres.getWiringSupport();
            if (!wiringSupport.isEffective()) continue;
            Wiring wiring = wiringSupport.getWiring(true);
            if (wiring != null && xcap.adapt(XPackageCapability.class) != null) {
                String pkgname = xcap.adapt(XPackageCapability.class).getPackageName();
                for (Wire wire : wiring.getRequiredResourceWires(cap.getNamespace())) {
                    XRequirement wirereq = (XRequirement)wire.getRequirement();
                    XPackageRequirement preq = wirereq.adapt(XPackageRequirement.class);
                    if (!pkgname.equals(preq.getPackageName())) continue;
                    ignoreCapability = true;
                    break;
                }
            }
            if (ignoreCapability) continue;
            List hostreqs = capres.getRequirements("osgi.wiring.host");
            if (wiring == null && !hostreqs.isEmpty()) {
                boolean unresolvedHost = false;
                XRequirement hostreq = (XRequirement)hostreqs.get(0);
                Set<Capability> hostcaps = this.capabilityCache.get(CacheKey.create(hostreq));
                if (hostcaps != null) {
                    for (Capability hostcap : hostcaps) {
                        XResource host;
                        if (!hostreq.matches(hostcap) || (host = (XResource)hostcap.getResource()).getWiringSupport().getWiring(true) != null) continue;
                        unresolvedHost = true;
                        break;
                    }
                }
                boolean bl = ignoreCapability = !unresolvedHost;
            }
            if (ignoreCapability) continue;
            result.add(cap);
        }
        ResolverHookProcessor hookregs = ResolverHookProcessor.getCurrentProcessor();
        if (hookregs != null && req instanceof BundleRequirement) {
            ArrayList<BundleCapability> bcaps = new ArrayList();
            for (Capability cap : result) {
                XResource res = (XResource)cap.getResource();
                if (res.getWiringSupport().getWiring(true) == null && !hookregs.hasResource(res)) continue;
                bcaps.add((BundleCapability)cap);
            }
            bcaps = new RemoveOnlyCollection(bcaps);
            hookregs.filterMatches((BundleRequirement)req, bcaps);
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Capability cap;
                cap = (Capability)iterator.next();
                if (bcaps.contains(cap)) continue;
                iterator.remove();
            }
        }
        ResolverLogger.LOGGER.tracef("Env provides: %s => %s", req, result);
        return result;
    }

    @Override
    public synchronized Map<Resource, Wiring> updateWiring(Map<Resource, List<Wire>> wiremap) {
        if (wiremap == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("wiremap");
        }
        HashMap<XResource, Wiring> result = new HashMap<XResource, Wiring>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            XResource requirer = (XResource)entry.getKey();
            List<Wire> reqwires = entry.getValue();
            Wiring reqwiring = requirer.getWiringSupport().getWiring(true);
            if (reqwiring == null) {
                reqwiring = this.createWiring(requirer, reqwires, null);
                requirer.getWiringSupport().setWiring(reqwiring);
            } else {
                for (Wire wire : reqwires) {
                    ((XWiring)reqwiring).addRequiredWire(wire);
                }
            }
            result.put(requirer, reqwiring);
            for (Wire wire : reqwires) {
                XResource provider = (XResource)wire.getProvider();
                Wiring provwiring = provider.getWiringSupport().getWiring(true);
                if (provwiring == null) {
                    provwiring = this.createWiring(provider, null, null);
                    provider.getWiringSupport().setWiring(provwiring);
                }
                ((XWiring)provwiring).addProvidedWire(wire);
            }
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Wiring createWiring(XResource res, List<Wire> required, List<Wire> provided) {
        return new AbstractWiring(res, required, provided);
    }

    @Override
    public synchronized Map<Resource, Wiring> getWirings() {
        HashMap<XResource, Wiring> result = new HashMap<XResource, Wiring>();
        for (XResource res : this.resourceIndexCache.values()) {
            Wiring wiring = res.getWiringSupport().getWiring(true);
            if (wiring == null) continue;
            result.put(res, wiring);
        }
        return Collections.unmodifiableMap(result);
    }

    private synchronized Set<Capability> getCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
            this.capabilityCache.put(key, capset);
        }
        return capset;
    }

    private synchronized Set<Capability> findCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
        }
        if (capset.isEmpty() && (key.value == null || key.hasFuzzyOperator())) {
            for (Map.Entry<CacheKey, Set<Capability>> entry : this.capabilityCache.entrySet()) {
                CacheKey auxkey = entry.getKey();
                if (!auxkey.namespace.equals(key.namespace)) continue;
                capset.addAll((Collection<Capability>)entry.getValue());
            }
        }
        return Collections.unmodifiableSet(capset);
    }

    private Set<XResource> getCachedResources(String type) {
        Set<XResource> typeset = this.resourceTypeCache.get(type);
        if (typeset == null) {
            typeset = new LinkedHashSet<XResource>();
            this.resourceTypeCache.put(type, typeset);
        }
        return typeset;
    }

    private static class CacheKey {
        private final String namespace;
        private final String value;
        private final String keyspec;
        private final String operator;

        static CacheKey create(Capability cap) {
            String namespace = cap.getNamespace();
            String nsvalue = (String)cap.getAttributes().get(namespace);
            return new CacheKey(namespace, nsvalue, null);
        }

        static CacheKey create(Requirement req) {
            String namespace = req.getNamespace();
            StringBuffer opbuffer = new StringBuffer();
            String nsvalue = AbstractRequirement.getNamespaceValue(req, opbuffer);
            String operator = opbuffer.length() > 0 ? opbuffer.toString() : null;
            return new CacheKey(namespace, nsvalue, operator);
        }

        private CacheKey(String namespace, String value, String operator) {
            this.namespace = namespace;
            this.value = value;
            this.operator = operator;
            this.keyspec = namespace + ":" + value;
        }

        boolean hasFuzzyOperator() {
            return this.operator != null && !this.operator.equals("=");
        }

        public int hashCode() {
            return this.keyspec.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.keyspec.equals(other.keyspec);
        }

        public String toString() {
            return "[" + this.keyspec + "]";
        }
    }
}

