/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XCapabilityRequirement;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XHostRequirement;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceRequirement;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AttributeSupporter;
import org.jboss.osgi.resolver.spi.DirectiveSupporter;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class AbstractRequirement
extends AbstractElement
implements XHostRequirement,
XPackageRequirement,
XResourceRequirement,
XCapabilityRequirement {
    private final XResource resource;
    private final String namespace;
    private XAttributeSupport attributes;
    private XDirectiveSupport directives;
    private String canonicalName;
    private boolean optional;
    private Filter filter;
    private boolean valid;

    public AbstractRequirement(XResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        if (namespace == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("namespace");
        }
        if (atts == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("attributes");
        }
        if (dirs == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AttributeSupporter(atts);
        this.directives = new DirectiveSupporter(dirs);
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public Resource getResource() {
        return this.resource;
    }

    static String getNamespaceValue(Requirement req) {
        return AbstractRequirement.getNamespaceValue(req, null);
    }

    static String getNamespaceValue(Requirement req, StringBuffer operator) {
        return AbstractRequirement.getValueFromFilter(AbstractRequirement.getFilterFromDirective(req), req.getNamespace(), operator);
    }

    @Override
    public void validate() {
        if (!this.valid) {
            Map<String, Object> atts = this.attributes.getAttributes();
            Map<String, String> dirs = this.directives.getDirectives();
            if (this.namespace.startsWith("osgi.wiring.")) {
                if (!atts.isEmpty()) {
                    this.generateFilterDirective(this.namespace, atts, dirs);
                }
                if (!dirs.containsKey("filter")) {
                    throw ResolverMessages.MESSAGES.illegalArgumentRequirementMustHaveFilterDirective(this.namespace, dirs);
                }
            }
            this.filter = AbstractRequirement.getFilterFromDirective(this);
            this.attributes = new AttributeSupporter(Collections.unmodifiableMap(atts));
            this.directives = new DirectiveSupporter(Collections.unmodifiableMap(dirs));
            String resdir = this.getDirective("resolution");
            this.optional = "optional".equals(resdir);
            this.canonicalName = this.toString();
            this.valid = true;
        }
    }

    public static Filter getFilterFromDirective(Requirement req) {
        String filterdir = (String)req.getDirectives().get("filter");
        if (filterdir != null) {
            try {
                return FrameworkUtil.createFilter((String)filterdir);
            }
            catch (InvalidSyntaxException e) {
                throw ResolverMessages.MESSAGES.illegalArgumentInvalidFilterDirective(filterdir);
            }
        }
        return null;
    }

    private static String getValueFromFilter(Filter filter, String attrname, StringBuffer operator) {
        String filterstr;
        int index;
        String result = null;
        if (filter != null && (index = (filterstr = filter.toString()).indexOf("(" + attrname)) >= 0) {
            char ch = filterstr.charAt(index += attrname.length() + 1);
            while ("~<=>".indexOf(ch) >= 0) {
                if (operator != null) {
                    operator.append(ch);
                }
                ch = filterstr.charAt(++index);
            }
            result = filterstr.substring(index);
            result = result.substring(0, result.indexOf(")"));
        }
        return result;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public <T extends XRequirement> T adapt(Class<T> clazz) {
        AbstractRequirement result = null;
        if (XResourceRequirement.class == clazz && "osgi.wiring.bundle".equals(this.getNamespace())) {
            result = this;
        } else if (XHostRequirement.class == clazz && "osgi.wiring.host".equals(this.getNamespace())) {
            result = this;
        } else if (XPackageRequirement.class == clazz && "osgi.wiring.package".equals(this.getNamespace())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public boolean matches(Capability cap) {
        boolean matches;
        this.assertImmutable();
        boolean bl = matches = this.namespace.equals(cap.getNamespace()) && this.matchFilter(cap);
        if (matches) {
            if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                matches = this.matchesResourceRequirement(cap);
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                matches = this.matchesHostRequirement(cap);
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                matches = this.matchesPackageRequirement(cap);
            } else {
                Object reqval = this.getAttribute(this.getNamespace());
                Object capval = cap.getAttributes().get(this.getNamespace());
                matches = reqval == null || reqval.equals(capval);
            }
        }
        return matches;
    }

    private boolean matchesResourceRequirement(Capability cap) {
        if (this.getResource() == cap.getResource()) {
            return false;
        }
        return this.matchesMandatoryDirective(cap);
    }

    private boolean matchesHostRequirement(Capability cap) {
        return this.matchesMandatoryDirective(cap);
    }

    private boolean matchesPackageRequirement(Capability cap) {
        return this.matchesMandatoryDirective(cap);
    }

    private boolean matchesMandatoryDirective(Capability cap) {
        String dirstr = ((XCapability)cap).getDirective("mandatory");
        if (dirstr != null) {
            for (String attname : dirstr.split("[,\\s]")) {
                String attval = AbstractRequirement.getValueFromFilter(this.filter, attname, null);
                if (attval != null) continue;
                return false;
            }
        }
        return true;
    }

    static VersionRange getVersionRange(XRequirement req, String attr) {
        Object value = req.getAttribute(attr);
        return value instanceof String ? new VersionRange((String)value) : (VersionRange)value;
    }

    private boolean matchFilter(Capability cap) {
        Map capatts = cap.getAttributes();
        return this.filter != null ? this.filter.matches(capatts) : true;
    }

    @Override
    public String getVisibility() {
        return this.getDirective("visibility");
    }

    @Override
    public String getSymbolicName() {
        String result = null;
        if ("osgi.wiring.host".equals(this.getNamespace())) {
            result = AbstractRequirement.getNamespaceValue(this);
        }
        return result;
    }

    @Override
    public String getPackageName() {
        String result = null;
        if ("osgi.wiring.package".equals(this.getNamespace())) {
            result = AbstractRequirement.getNamespaceValue(this);
        }
        return result;
    }

    @Override
    public VersionRange getVersionRange() {
        VersionRange result = null;
        if ("osgi.wiring.host".equals(this.getNamespace()) || "osgi.wiring.bundle".equals(this.getNamespace())) {
            result = AbstractRequirement.getVersionRange(this, "bundle-version");
        } else if ("osgi.wiring.package".equals(this.getNamespace())) {
            result = AbstractRequirement.getVersionRange(this, "version");
        }
        return result;
    }

    @Override
    public boolean isDynamic() {
        return "dynamic".equals(this.getDirective("resolution"));
    }

    private void generateFilterDirective(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        ArrayList<String> parts = new ArrayList<String>();
        if (atts.containsKey(namespace)) {
            this.addAttributePart(atts, namespace, parts);
            this.addVersionRangePart(atts, "bundle-version", parts);
            this.addVersionRangePart(atts, "version", parts);
            for (String key : new ArrayList<String>(atts.keySet())) {
                this.addAttributePart(atts, key, parts);
            }
            StringBuffer filterSpec = new StringBuffer((String)parts.remove(0));
            for (String part : parts) {
                filterSpec.insert(0, "(&");
                filterSpec.append(part + ")");
            }
            try {
                Filter filter = FrameworkUtil.createFilter((String)filterSpec.toString());
                dirs.put("filter", filter.toString());
            }
            catch (InvalidSyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }
    }

    private void addAttributePart(Map<String, Object> atts, String attrname, List<String> parts) {
        Object attrval = atts.remove(attrname);
        if (attrval instanceof String) {
            parts.add("(" + attrname + "=" + attrval + ")");
        }
    }

    private void addVersionRangePart(Map<String, Object> atts, String attrname, List<String> parts) {
        Object versionAtt = atts.remove(attrname);
        if (versionAtt instanceof VersionRange) {
            VersionRange versionRange = (VersionRange)versionAtt;
            parts.add(versionRange.toFilterString(attrname));
        } else if (versionAtt instanceof String) {
            VersionRange versionRange = new VersionRange((String)versionAtt);
            parts.add(versionRange.toFilterString(attrname));
        }
    }

    private boolean isMutable() {
        return this.resource.isMutable();
    }

    private void assertImmutable() {
        if (this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToMutableResource();
        }
    }

    public String toString() {
        String result = this.canonicalName;
        if (result == null) {
            XIdentityCapability icap;
            String type;
            String nsval = null;
            if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                type = XResourceRequirement.class.getSimpleName();
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                type = XHostRequirement.class.getSimpleName();
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                type = XPackageRequirement.class.getSimpleName();
            } else {
                type = XCapabilityRequirement.class.getSimpleName();
                nsval = this.namespace;
            }
            StringBuffer buffer = new StringBuffer(type + "[");
            boolean addcomma = false;
            if (nsval != null) {
                buffer.append(nsval);
                addcomma = true;
            }
            if (!this.getAttributes().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("atts=" + this.attributes);
                addcomma = true;
            }
            if (!this.getDirectives().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("dirs=" + this.directives);
                addcomma = true;
            }
            if ((icap = this.resource.getIdentityCapability()) != null) {
                buffer.append(addcomma ? "," : "");
                buffer.append("[" + icap.getSymbolicName() + ":" + icap.getVersion() + "]");
                addcomma = true;
            } else {
                buffer.append(addcomma ? "," : "");
                buffer.append("[anonymous]");
                addcomma = true;
            }
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }
}

