/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.repository.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.jboss.osgi.repository.RepositoryMessages;
import org.jboss.osgi.repository.RepositoryStorage;
import org.jboss.osgi.repository.RepositoryStorageFactory;
import org.jboss.osgi.repository.XPersistentRepository;
import org.jboss.osgi.repository.XRepository;
import org.jboss.osgi.repository.spi.AbstractRepository;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class AbstractPersistentRepository
extends AbstractRepository
implements XPersistentRepository {
    private final RepositoryStorage storage;
    private final XRepository delegate;

    public AbstractPersistentRepository(RepositoryStorageFactory factory, XRepository delegate) {
        if (factory == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("factory");
        }
        if (delegate == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("delegate");
        }
        this.storage = factory.create(this);
        this.delegate = delegate;
    }

    @Override
    public Collection<Capability> findProviders(Requirement req) {
        if (req == null) {
            throw RepositoryMessages.MESSAGES.illegalArgumentNull("req");
        }
        Collection<Capability> providers = this.storage.findProviders(req);
        if (providers.isEmpty()) {
            providers = this.delegate.findProviders(req);
            ArrayList<Capability> caplist = new ArrayList<Capability>(providers);
            for (int i = 0; i < caplist.size(); ++i) {
                XCapability orgcap = (XCapability)caplist.get(i);
                XResource orgres = (XResource)orgcap.getResource();
                XResource newres = this.storage.addResource(orgres);
                if (newres == orgres) continue;
                String namespace = orgcap.getNamespace();
                Object orgval = orgcap.getAttributes().get(namespace);
                for (Capability newcap : newres.getCapabilities(namespace)) {
                    Object newval = newcap.getAttributes().get(namespace);
                    if (!orgval.equals(newval)) continue;
                    caplist.set(i, newcap);
                }
            }
            providers = caplist;
        }
        return providers;
    }

    @Override
    public RepositoryStorage getRepositoryStorage() {
        return this.storage;
    }
}

