/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimplePersistentResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.io.BufferPoolService;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.IOServices;

class BufferPoolResourceDefinition
extends SimplePersistentResourceDefinition {
    static final SimpleAttributeDefinition BUFFER_SIZE = new SimpleAttributeDefinitionBuilder("buffer-size", ModelType.INT).setDefaultValue(new ModelNode(1024)).build();
    static final SimpleAttributeDefinition BUFFER_PER_SLICE = new SimpleAttributeDefinitionBuilder("buffers-per-slice", ModelType.INT).setDefaultValue(new ModelNode(1024)).build();
    static List<SimpleAttributeDefinition> ATTRIBUTES = Arrays.asList(BUFFER_SIZE, BUFFER_PER_SLICE);
    public static final BufferPoolResourceDefinition INSTANCE = new BufferPoolResourceDefinition();

    private BufferPoolResourceDefinition() {
        super(IOExtension.BUFFER_POOL_PATH, (ResourceDescriptionResolver)IOExtension.getResolver("buffer-pool"), (OperationStepHandler)new BufferPoolAdd(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public Collection<AttributeDefinition> getAttributes() {
        return ATTRIBUTES;
    }

    private static class BufferPoolAdd
    extends AbstractAddStepHandler {
        private BufferPoolAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attributeDefinition : ATTRIBUTES) {
                attributeDefinition.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            String name = address.getLastElement().getValue();
            int bufferSize = BUFFER_SIZE.resolveModelAttribute(context, model).asInt();
            int bufferPerSlice = BUFFER_PER_SLICE.resolveModelAttribute(context, model).asInt();
            BufferPoolService service = new BufferPoolService(bufferSize, bufferPerSlice);
            ServiceBuilder serviceBuilder = context.getServiceTarget().addService(IOServices.BUFFER_POOL.append(new String[]{name}), (Service)service);
            serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            ServiceController serviceController = serviceBuilder.install();
            if (newControllers != null) {
                newControllers.add(serviceController);
            }
        }
    }
}

