/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.common.beans.property;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.jboss.common.beans.property.BeanUtils;
import org.jboss.common.beans.property.PropertyEditorSupport;

public class URLEditor
extends PropertyEditorSupport<URL> {
    public URLEditor() {
        super(URL.class);
    }

    @Override
    public void setAsText(String text) {
        if (BeanUtils.isNull(text)) {
            this.setValue(null);
            return;
        }
        try {
            this.setValue(URLEditor.toURL(text));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to parse to URI!", e);
        }
    }

    @Override
    public String getAsText() {
        URL u = (URL)this.getValue();
        if (u == null) {
            return null;
        }
        String stringValue = u.toString();
        if (stringValue.startsWith("file")) {
            try {
                stringValue = URLDecoder.decode(stringValue, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Failed to parse to URL!", e);
            }
        }
        return stringValue;
    }

    public static URL toURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                url = URLEditor.makeURLFromFilespec(url.getFile());
            }
        }
        catch (Exception e) {
            try {
                url = URLEditor.makeURLFromFilespec(urlspec);
            }
            catch (IOException n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static URL makeURLFromFilespec(String filespec) throws IOException {
        String decoded = URLDecoder.decode(filespec, "UTF-8");
        File file = new File(decoded);
        file = file.getCanonicalFile();
        return file.toURI().toURL();
    }
}

