/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.tx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.core.CoreBundle;
import org.jboss.jca.core.CoreLogger;
import org.jboss.jca.core.api.connectionmanager.ConnectionManager;
import org.jboss.jca.core.connectionmanager.AbstractConnectionManager;
import org.jboss.jca.core.connectionmanager.ConnectionRecord;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.listener.ConnectionListener;
import org.jboss.jca.core.connectionmanager.listener.TxConnectionListener;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPool;
import org.jboss.jca.core.connectionmanager.transaction.LockKey;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.TransactionTimeoutConfiguration;
import org.jboss.jca.core.spi.transaction.TxUtils;
import org.jboss.logging.Logger;
import org.jboss.logging.Messages;

public class TxConnectionManagerImpl
extends AbstractConnectionManager
implements TxConnectionManager {
    private static CoreLogger log = (CoreLogger)Logger.getMessageLogger(CoreLogger.class, (String)TxConnectionManager.class.getName());
    private static final long serialVersionUID = 1L;
    private static CoreBundle bundle = (CoreBundle)Messages.getBundle(CoreBundle.class);
    private transient TransactionManager transactionManager;
    private transient TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private TransactionIntegration txIntegration;
    private boolean interleaving;
    private boolean localTransactions;
    private int xaResourceTimeout = 0;
    private boolean padXid;
    private boolean wrapXAResource = true;
    private Boolean isSameRMOverride;

    public TxConnectionManagerImpl(TransactionIntegration txIntegration, boolean localTransactions) {
        if (txIntegration == null) {
            throw new IllegalArgumentException("TransactionIntegration is null");
        }
        this.transactionManager = txIntegration.getTransactionManager();
        this.transactionSynchronizationRegistry = txIntegration.getTransactionSynchronizationRegistry();
        this.txIntegration = txIntegration;
        this.setLocalTransactions(localTransactions);
    }

    @Override
    protected CoreLogger getLogger() {
        return log;
    }

    @Override
    public TransactionIntegration getTransactionIntegration() {
        return this.txIntegration;
    }

    @Override
    public boolean isInterleaving() {
        return this.interleaving;
    }

    public void setInterleaving(boolean value) {
        this.interleaving = value;
    }

    @Override
    public boolean isLocalTransactions() {
        return this.localTransactions;
    }

    void setLocalTransactions(boolean v) {
        this.localTransactions = v;
        if (v) {
            this.setInterleaving(false);
        }
    }

    @Override
    public int getXAResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public void setXAResourceTimeout(int timeout) {
        this.xaResourceTimeout = timeout;
    }

    @Override
    public Boolean getIsSameRMOverride() {
        return this.isSameRMOverride;
    }

    public void setIsSameRMOverride(Boolean v) {
        this.isSameRMOverride = v;
    }

    @Override
    public boolean getWrapXAResource() {
        return this.wrapXAResource;
    }

    public void setWrapXAResource(boolean v) {
        this.wrapXAResource = v;
    }

    @Override
    public boolean getPadXid() {
        return this.padXid;
    }

    public void setPadXid(boolean v) {
        this.padXid = v;
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        if (this.transactionManager == null) {
            throw new IllegalStateException("No transaction manager: " + this.getCachedConnectionManager());
        }
        if (this.transactionManager instanceof TransactionTimeoutConfiguration) {
            return ((TransactionTimeoutConfiguration)this.transactionManager).getTimeLeftBeforeTransactionTimeout(errorRollback);
        }
        return -1L;
    }

    @Override
    public ConnectionListener getManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Transaction trackByTransaction = null;
        try {
            Transaction tx = this.transactionManager.getTransaction();
            if (tx != null && !TxUtils.isActive((Transaction)tx)) {
                throw new ResourceException(bundle.transactionNotActive(tx));
            }
            if (!this.interleaving) {
                trackByTransaction = tx;
            }
        }
        catch (Throwable t) {
            throw new ResourceException(bundle.errorCheckingForTransaction(), t);
        }
        if (this.trace) {
            log.tracef("getManagedConnection interleaving=%s , tx=%s", this.interleaving, trackByTransaction);
        }
        return super.getManagedConnection(trackByTransaction, subject, cri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionStarted(Collection<ConnectionRecord> crs) throws SystemException {
        HashSet<ConnectionListener> cls = new HashSet<ConnectionListener>(crs.size());
        for (ConnectionRecord cr : crs) {
            ConnectionListener cl = cr.getConnectionListener();
            if (cls.contains(cl)) continue;
            cls.add(cl);
            cl.enlist();
            if (this.isInterleaving()) continue;
            cl.setTrackByTx(true);
            ManagedConnectionPool mcp = (ManagedConnectionPool)cl.getContext();
            Transaction tx = this.transactionManager.getTransaction();
            Lock lock = this.getLock();
            try {
                lock.lockInterruptibly();
            }
            catch (Throwable t) {
                TxConnectionManagerImpl.rethrowAsSystemException("Unable to begin transaction with JCA lazy enlistment scenario", tx, t);
            }
            try {
                this.transactionSynchronizationRegistry.putResource((Object)mcp, (Object)cl);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private synchronized Lock initLock() {
        if (this.transactionSynchronizationRegistry != null && this.transactionSynchronizationRegistry.getTransactionKey() != null) {
            if (this.transactionSynchronizationRegistry.getResource((Object)LockKey.INSTANCE) == null) {
                ReentrantLock lock = new ReentrantLock(true);
                this.transactionSynchronizationRegistry.putResource((Object)LockKey.INSTANCE, (Object)lock);
                return lock;
            }
            return (Lock)this.transactionSynchronizationRegistry.getResource((Object)LockKey.INSTANCE);
        }
        return null;
    }

    private Lock getLock() {
        Lock result = null;
        if (this.transactionSynchronizationRegistry != null && this.transactionSynchronizationRegistry.getTransactionKey() != null && (result = (Lock)this.transactionSynchronizationRegistry.getResource((Object)LockKey.INSTANCE)) == null) {
            result = this.initLock();
        }
        return result;
    }

    @Override
    protected void managedConnectionReconnected(ConnectionListener cl) throws ResourceException {
        try {
            cl.enlist();
        }
        catch (Throwable t) {
            if (this.trace) {
                log.trace("Could not enlist in transaction on entering meta-aware object! " + cl, t);
            }
            throw new ResourceException(bundle.notEnlistInTransactionOnEnteringMetaAwareObject(), t);
        }
    }

    @Override
    protected void managedConnectionDisconnected(ConnectionListener cl) throws ResourceException {
        Throwable throwable = null;
        try {
            cl.delist();
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (cl.isManagedConnectionFree()) {
            if (this.trace) {
                log.tracef("Disconnected isManagedConnectionFree=true cl=%s", cl);
            }
            this.returnManagedConnection(cl, false);
        } else if (this.trace) {
            log.tracef("Disconnected isManagedConnectionFree=false cl=%s", cl);
        }
        if (throwable != null) {
            throw new ResourceException(bundle.couldNotDelistResourceThenTransactionRollback(), throwable);
        }
    }

    @Override
    public ConnectionListener createConnectionListener(ManagedConnection mc, Object context) throws ResourceException {
        String eisProductName;
        XAResource xaResource = null;
        if (this.localTransactions) {
            eisProductName = null;
            String eisProductVersion = null;
            try {
                if (mc.getMetaData() != null) {
                    eisProductName = mc.getMetaData().getEISProductName();
                    eisProductVersion = mc.getMetaData().getEISProductVersion();
                }
            }
            catch (ResourceException re) {
                // empty catch block
            }
            if (eisProductName == null) {
                eisProductName = this.getJndiName();
            }
            if (eisProductVersion == null) {
                eisProductVersion = this.getJndiName();
            }
            xaResource = this.txIntegration.createLocalXAResource((ConnectionManager)this, eisProductName, eisProductVersion, this.getJndiName());
            if (this.xaResourceTimeout != 0) {
                log.debug("XAResource transaction timeout cannot be set for local transactions: " + this.getJndiName());
            }
        } else {
            if (this.wrapXAResource) {
                eisProductName = null;
                String eisProductVersion = null;
                try {
                    if (mc.getMetaData() != null) {
                        eisProductName = mc.getMetaData().getEISProductName();
                        eisProductVersion = mc.getMetaData().getEISProductVersion();
                    }
                }
                catch (ResourceException re) {
                    // empty catch block
                }
                if (eisProductName == null) {
                    eisProductName = this.getJndiName();
                }
                if (eisProductVersion == null) {
                    eisProductVersion = this.getJndiName();
                }
                if (this.trace) {
                    log.tracef("Generating XAResourceWrapper for TxConnectionManager (%s)", this);
                }
                xaResource = this.txIntegration.createXAResourceWrapper(mc.getXAResource(), this.padXid, this.isSameRMOverride, eisProductName, eisProductVersion, this.getJndiName());
            } else {
                if (this.trace) {
                    log.tracef("Not wrapping XAResource.", new Object[0]);
                }
                xaResource = mc.getXAResource();
            }
            if (this.xaResourceTimeout != 0) {
                try {
                    if (!xaResource.setTransactionTimeout(this.xaResourceTimeout)) {
                        log.debug("XAResource does not support transaction timeout configuration: " + this.getJndiName());
                    }
                }
                catch (XAException e) {
                    throw new ResourceException(bundle.unableSetXAResourceTransactionTimeout(this.getJndiName()), (Throwable)e);
                }
            }
        }
        TxConnectionListener cli = new TxConnectionListener(this, mc, this.getPool(), context, this.getFlushStrategy(), xaResource);
        mc.addConnectionEventListener((ConnectionEventListener)cli);
        return cli;
    }

    @Override
    public boolean isTransactional() {
        try {
            return !TxUtils.isCompleted((Transaction)this.transactionManager.getTransaction());
        }
        catch (SystemException se) {
            throw new RuntimeException("Error during isTransactional()", se);
        }
    }

    public int getTransactionTimeout() throws SystemException {
        throw new RuntimeException("NYI: getTransactionTimeout()");
    }

    public static void rethrowAsSystemException(String context, Transaction tx, Throwable t) throws SystemException {
        if (t instanceof SystemException) {
            throw (SystemException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RollbackException) {
            throw new IllegalStateException(context + " tx=" + tx + " marked for rollback.");
        }
        throw new RuntimeException(context + " tx=" + tx + " got unexpected error ", t);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }
}

