/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import java.lang.reflect.Constructor;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.xts.XTSDeploymentMarker;
import org.jboss.as.xts.XtsAsMessages;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.weld.metadata.MetadataImpl;

public class CDIExtensionProcessor
implements DeploymentUnitProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] EXTENSIONS = new String[]{"org.jboss.narayana.txframework.impl.as.TXFrameworkCDIExtension"};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (!XTSDeploymentMarker.isXTSAnnotationDeployment(unit)) {
            return;
        }
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)unit.getAttachment(Attachments.REFLECTION_INDEX);
        ModuleClassLoader cl = ((Module)unit.getAttachment(Attachments.MODULE)).getClassLoader();
        for (String fqn : EXTENSIONS) {
            Extension extension = this.loadExtension(fqn, index, (ClassLoader)cl);
            MetadataImpl metadata = new MetadataImpl((Object)extension, unit.getName());
            unit.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
        }
    }

    private Extension loadExtension(String serviceClassName, DeploymentReflectionIndex index, ClassLoader loader) throws DeploymentUnitProcessingException {
        try {
            Class<?> serviceClass = loader.loadClass(serviceClassName);
            Constructor ctor = index.getClassIndex(serviceClass).getConstructor(EMPTY_STRING_ARRAY);
            return (Extension)ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw XtsAsMessages.MESSAGES.cannotLoadCDIExtension();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

