/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts.jandex;

import javax.xml.namespace.QName;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.xts.XTSException;
import org.jboss.as.xts.jandex.JandexHelper;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class WebServiceAnnotation {
    private static final String WEBSERVICE_ANNOTATION = "javax.jws.WebService";
    private String portName;
    private String serviceName;
    private String name;
    private String targetNamespace;

    private WebServiceAnnotation(String portName, String serviceName, String name, String targetNamespace) {
        this.portName = portName;
        this.serviceName = serviceName;
        this.name = name;
        this.targetNamespace = targetNamespace;
    }

    public static WebServiceAnnotation build(DeploymentUnit unit, String endpoint) throws XTSException {
        AnnotationInstance annotationInstance = JandexHelper.getAnnotation(unit, endpoint, WEBSERVICE_ANNOTATION);
        if (annotationInstance == null) {
            return null;
        }
        String portName = WebServiceAnnotation.getStringVaue(annotationInstance, "portName");
        String serviceName = WebServiceAnnotation.getStringVaue(annotationInstance, "serviceName");
        String name = WebServiceAnnotation.getStringVaue(annotationInstance, "name");
        String targetNamespace = WebServiceAnnotation.getStringVaue(annotationInstance, "targetNamespace");
        return new WebServiceAnnotation(portName, serviceName, name, targetNamespace);
    }

    private static String getStringVaue(AnnotationInstance annotationInstance, String key) {
        AnnotationValue value = annotationInstance.value(key);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public QName buildPortQName() {
        return new QName(this.targetNamespace, this.portName);
    }

    public String getPortName() {
        return this.portName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }
}

