/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collection;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.value.Value;

public final class DelegatingServiceBuilder<T>
implements ServiceBuilder<T> {
    private final ServiceBuilder<T> delegate;

    public DelegatingServiceBuilder(ServiceBuilder<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ServiceBuilder<T> addAliases(ServiceName ... aliases) {
        this.delegate.addAliases(aliases);
        return this;
    }

    @Override
    public ServiceBuilder<T> setInitialMode(ServiceController.Mode mode) {
        this.delegate.setInitialMode(mode);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceName ... dependencies) {
        this.delegate.addDependencies(dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, ServiceName ... dependencies) {
        this.delegate.addDependencies(dependencyType, dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(Iterable<ServiceName> dependencies) {
        this.delegate.addDependencies(dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependencies(ServiceBuilder.DependencyType dependencyType, Iterable<ServiceName> dependencies) {
        this.delegate.addDependencies(dependencyType, dependencies);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency) {
        this.delegate.addDependency(dependency);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency) {
        this.delegate.addDependency(dependencyType, dependency);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceName dependency, Injector<Object> target) {
        this.delegate.addDependency(dependency, target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Injector<Object> target) {
        this.delegate.addDependency(dependencyType, dependency, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceName dependency, Class<I> type, Injector<I> target) {
        this.delegate.addDependency(dependency, type, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addDependency(ServiceBuilder.DependencyType dependencyType, ServiceName dependency, Class<I> type, Injector<I> target) {
        this.delegate.addDependency(dependencyType, dependency, type, target);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addInjection(Injector<? super I> target, I value) {
        this.delegate.addInjection(target, value);
        return this;
    }

    @Override
    public <I> ServiceBuilder<T> addInjectionValue(Injector<? super I> target, Value<I> value) {
        this.delegate.addInjectionValue(target, value);
        return this;
    }

    @Override
    public ServiceBuilder<T> addInjection(Injector<? super T> target) {
        this.delegate.addInjection(target);
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitor(StabilityMonitor monitor) {
        this.delegate.addMonitor(monitor);
        return this;
    }

    @Override
    public ServiceBuilder<T> addMonitors(StabilityMonitor ... monitors) {
        this.delegate.addMonitors(monitors);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> listener) {
        this.delegate.addListener(listener);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener<? super T> ... listeners) {
        this.delegate.addListener(listeners);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(Collection<? extends ServiceListener<? super T>> listeners) {
        this.delegate.addListener(listeners);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> listener) {
        this.delegate.addListener(inheritance, listener);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, ServiceListener<? super T> ... listeners) {
        this.delegate.addListener(inheritance, listeners);
        return this;
    }

    @Override
    public ServiceBuilder<T> addListener(ServiceListener.Inheritance inheritance, Collection<? extends ServiceListener<? super T>> listeners) {
        this.delegate.addListener(inheritance, listeners);
        return this;
    }

    @Override
    public ServiceController<T> install() throws ServiceRegistryException {
        return this.delegate.install();
    }
}

