/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.BlockingHttpExchange;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.servlet.api.ServletDispatcher;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.ApplicationListeners;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ServletBlockingHttpExchange;
import io.undertow.servlet.handlers.ServletChain;
import io.undertow.servlet.handlers.ServletPathMatch;
import io.undertow.servlet.handlers.ServletPathMatches;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.RequestDispatcherImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.io.Closeable;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.xnio.IoUtils;

public class ServletInitialHandler
implements HttpHandler,
ServletDispatcher {
    private final HttpHandler next;
    private final CompositeThreadSetupAction setupAction;
    private final ServletContextImpl servletContext;
    private final ApplicationListeners listeners;
    private final ServletPathMatches paths;

    public ServletInitialHandler(ServletPathMatches paths, HttpHandler next, CompositeThreadSetupAction setupAction, ServletContextImpl servletContext) {
        this.next = next;
        this.setupAction = setupAction;
        this.servletContext = servletContext;
        this.paths = paths;
        this.listeners = servletContext.getDeployment().getApplicationListeners();
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        String path = exchange.getRelativePath();
        ServletPathMatch info = this.paths.getServletHandlerByPath(path);
        HttpServletResponseImpl response = new HttpServletResponseImpl(exchange, this.servletContext);
        HttpServletRequestImpl request = new HttpServletRequestImpl(exchange, this.servletContext);
        ServletRequestContext servletRequestContext = new ServletRequestContext(request, response);
        exchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
        try {
            exchange.startBlocking((BlockingHttpExchange)new ServletBlockingHttpExchange(exchange));
            servletRequestContext.setServletPathMatch(info);
            this.dispatchRequest(exchange, servletRequestContext, info, DispatcherType.REQUEST);
        }
        catch (Throwable t) {
            UndertowLogger.REQUEST_LOGGER.errorf(t, "Internal error handling servlet request %s", (Object)exchange.getRequestURI());
            exchange.endExchange();
        }
    }

    @Override
    public void dispatchToPath(HttpServerExchange exchange, ServletPathMatch pathInfo, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        servletRequestContext.setServletPathMatch(pathInfo);
        this.dispatchRequest(exchange, servletRequestContext, pathInfo, dispatcherType);
    }

    @Override
    public void dispatchToServlet(HttpServerExchange exchange, ServletChain servletchain, DispatcherType dispatcherType) throws Exception {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        this.dispatchRequest(exchange, servletRequestContext, servletchain, dispatcherType);
    }

    private void dispatchRequest(HttpServerExchange exchange, ServletRequestContext servletRequestContext, ServletChain servletChain, DispatcherType dispatcherType) throws Exception {
        servletRequestContext.setDispatcherType(dispatcherType);
        servletRequestContext.setCurrentServlet(servletChain);
        if (dispatcherType == DispatcherType.REQUEST || dispatcherType == DispatcherType.ASYNC) {
            this.handleFirstRequest(exchange, servletChain, servletRequestContext, servletRequestContext.getServletRequest(), servletRequestContext.getServletResponse());
        } else {
            this.next.handleRequest(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFirstRequest(HttpServerExchange exchange, ServletChain servletChain, ServletRequestContext servletRequestContext, ServletRequest request, ServletResponse response) throws Exception {
        try {
            ServletRequestContext.setCurrentRequestContext(servletRequestContext);
            ThreadSetupAction.Handle handle = this.setupAction.setup(exchange);
            try {
                String location;
                this.listeners.requestInitialized(request);
                this.next.handleRequest(exchange);
                if (!exchange.isResponseStarted() && exchange.getResponseCode() >= 400 && !exchange.isDispatched() && (location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(exchange.getResponseCode())) != null) {
                    RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                    dispatcher.error(request, response, servletChain.getManagedServlet().getServletInfo().getName());
                }
            }
            catch (Throwable t) {
                if (request.isAsyncStarted() || request.getDispatcherType() == DispatcherType.ASYNC) {
                    exchange.unDispatch();
                    servletRequestContext.getOriginalRequest().getAsyncContextInternal().handleError(t);
                } else if (!exchange.isResponseStarted()) {
                    exchange.setResponseCode(500);
                    exchange.getResponseHeaders().clear();
                    String location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t);
                    if (location == null && t instanceof ServletException) {
                        location = this.servletContext.getDeployment().getErrorPages().getErrorLocation(t.getCause());
                    }
                    if (location != null) {
                        RequestDispatcherImpl dispatcher = new RequestDispatcherImpl(location, this.servletContext);
                        try {
                            dispatcher.error(request, response, servletChain.getManagedServlet().getServletInfo().getName(), t);
                        }
                        catch (Exception e) {
                            UndertowLogger.REQUEST_LOGGER.errorf((Throwable)e, "Exception while generating error page %s", (Object)location);
                        }
                    } else {
                        UndertowLogger.REQUEST_LOGGER.errorf(t, "Servlet request failed %s", (Object)exchange);
                    }
                }
            }
            finally {
                handle.tearDown();
            }
            this.servletContext.getDeployment().getApplicationListeners().requestDestroyed(request);
            if (!exchange.isDispatched()) {
                servletRequestContext.getOriginalResponse().responseDone();
                FormDataParser parser = (FormDataParser)exchange.getAttachment(FormDataParser.ATTACHMENT_KEY);
                IoUtils.safeClose((Closeable)parser);
            }
        }
        finally {
            ServletRequestContext.clearCurrentServletAttachments();
        }
    }

    public HttpHandler getNext() {
        return this.next;
    }
}

