/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.predicate;

import io.undertow.predicate.Predicate;
import io.undertow.server.HttpServerExchange;

class PrefixMatchPredicate
implements Predicate {
    private final String slashPath;
    private final String path;

    public PrefixMatchPredicate(String path) {
        if (path.startsWith("/")) {
            this.slashPath = path;
            this.path = path.substring(1);
        } else {
            this.slashPath = "/" + path;
            this.path = path;
        }
    }

    @Override
    public boolean resolve(HttpServerExchange value) {
        String relativePath = value.getRelativePath();
        if (relativePath.startsWith("/")) {
            return relativePath.startsWith(this.slashPath);
        }
        return relativePath.startsWith(this.path);
    }
}

