/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CookieImpl
implements Cookie {
    private final String name;
    private String value;
    private String path;
    private String domain;
    private Integer maxAge;
    private Date expires;
    private boolean discard;
    private boolean secure;
    private boolean httpOnly;
    private int version = 0;
    private String comment;

    public CookieImpl(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public CookieImpl(String name) {
        this.name = name;
    }

    public static Map<String, Cookie> getRequestCookies(HttpServerExchange exchange) {
        return (Map)exchange.getAttachment(REQUEST_COOKIES);
    }

    public static Map<String, Cookie> getResponseCookies(HttpServerExchange exchange) {
        Map ret = (Map)exchange.getAttachment(RESPONSE_COOKIES);
        if (ret == null) {
            return Collections.emptyMap();
        }
        return ret;
    }

    public static void addResponseCookie(HttpServerExchange exchange, Cookie cookie) {
        HashMap<String, Cookie> cookies = (HashMap<String, Cookie>)exchange.getAttachment(RESPONSE_COOKIES);
        if (cookies == null) {
            cookies = new HashMap<String, Cookie>();
            exchange.putAttachment(RESPONSE_COOKIES, cookies);
        }
        cookies.put(cookie.getName(), cookie);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public CookieImpl setValue(String value) {
        this.value = value;
        return this;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public CookieImpl setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    @Override
    public CookieImpl setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public Integer getMaxAge() {
        return this.maxAge;
    }

    @Override
    public CookieImpl setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    @Override
    public boolean isDiscard() {
        return this.discard;
    }

    @Override
    public CookieImpl setDiscard(boolean discard) {
        this.discard = discard;
        return this;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public CookieImpl setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public CookieImpl setVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public CookieImpl setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    @Override
    public Date getExpires() {
        return this.expires;
    }

    @Override
    public CookieImpl setExpires(Date expires) {
        this.expires = expires;
        return this;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public Cookie setComment(String comment) {
        this.comment = comment;
        return this;
    }
}

