/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class FileResourceManager
implements ResourceManager {
    private volatile Path base;

    public FileResourceManager(Path base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
    }

    public Path getBase() {
        return this.base;
    }

    public FileResourceManager setBase(Path base) {
        if (base == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("base");
        }
        this.base = base;
        return this;
    }

    @Override
    public Resource getResource(String p) {
        Path file;
        String path = p;
        if (p.startsWith("/")) {
            path = p.substring(1);
        }
        if (Files.exists(file = this.base.resolve(path), new LinkOption[0])) {
            return new FileResource(file);
        }
        return null;
    }
}

