/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.client;

import io.undertow.client.HttpClientCallback;
import io.undertow.client.HttpClientConnection;
import io.undertow.client.HttpClientRequest;
import io.undertow.client.HttpClientResponse;
import io.undertow.websockets.client.WebSocket13ClientHandshake;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.channels.ConnectedStreamChannel;

public abstract class WebSocketClientHandshake {
    protected final URI url;

    public static WebSocketClientHandshake create(WebSocketVersion version, URI uri) {
        switch (version) {
            case V13: {
                return new WebSocket13ClientHandshake(uri);
            }
        }
        throw new IllegalArgumentException();
    }

    public WebSocketClientHandshake(URI url) {
        this.url = url;
    }

    public abstract WebSocketChannel createChannel(ConnectedStreamChannel var1, String var2, Pool<ByteBuffer> var3);

    public abstract void setupRequest(HttpClientRequest var1);

    public abstract void verifyResponse(URI var1, HttpClientResponse var2, HttpClientConnection var3, HttpClientCallback<WebSocketChannel> var4) throws IOException;
}

