/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.config;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.MetadataProviderType;
import org.picketlink.identity.federation.core.config.TrustType;
import org.picketlink.identity.federation.core.util.StringUtil;

public class ProviderType {
    protected String identityURL;
    protected TrustType trust;
    protected KeyProviderType keyProvider;
    protected MetadataProviderType metaDataProvider;
    protected String serverEnvironment;
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected Map<String, Object> additionalOptions = new HashMap<String, Object>();
    protected boolean supportsSignature = false;

    public String getIdentityURL() {
        return this.identityURL;
    }

    public void setIdentityURL(String value) {
        this.identityURL = value;
    }

    public TrustType getTrust() {
        return this.trust;
    }

    public void setTrust(TrustType value) {
        this.trust = value;
    }

    public KeyProviderType getKeyProvider() {
        return this.keyProvider;
    }

    public void setKeyProvider(KeyProviderType value) {
        this.keyProvider = value;
    }

    public MetadataProviderType getMetaDataProvider() {
        return this.metaDataProvider;
    }

    public void setMetaDataProvider(MetadataProviderType value) {
        this.metaDataProvider = value;
    }

    public String getServerEnvironment() {
        if (this.serverEnvironment == null) {
            return "picketlink";
        }
        return this.serverEnvironment;
    }

    public void setServerEnvironment(String value) {
        this.serverEnvironment = value;
    }

    public String getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public void setCanonicalizationMethod(String canonicalizationMethod) {
        this.canonicalizationMethod = canonicalizationMethod;
    }

    public void addAdditionalOption(String key, Object value) {
        this.additionalOptions.put(key, value);
    }

    public void removeAdditionalOption(String key) {
        this.additionalOptions.remove(key);
    }

    public Object getAdditionalOption(String key) {
        return this.additionalOptions.get(key);
    }

    public void importFrom(ProviderType other) {
        KeyProviderType keyProvider = other.getKeyProvider();
        if (keyProvider != null) {
            this.setKeyProvider(keyProvider);
        }
        this.setSupportsSignature(other.isSupportsSignature());
        String can = other.getCanonicalizationMethod();
        if (StringUtil.isNotNull(can)) {
            this.setCanonicalizationMethod(can);
        }
        if (this.trust == null) {
            this.trust = other.getTrust();
        } else if (other.getTrust() != null) {
            this.trust.addDomain(other.getTrust().getDomains());
        }
        this.additionalOptions.putAll(other.additionalOptions);
    }

    public boolean isSupportsSignature() {
        return this.supportsSignature;
    }

    public void setSupportsSignature(boolean supportsSignature) {
        this.supportsSignature = supportsSignature;
    }
}

