/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.util;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;

public class SignatureUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static String getXMLSignatureAlgorithmURI(String algo) {
        String xmlSignatureAlgo = null;
        if ("DSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_DSA.get();
        } else if ("RSA".equalsIgnoreCase(algo)) {
            xmlSignatureAlgo = JBossSAMLConstants.SIGNATURE_SHA1_WITH_RSA.get();
        }
        return xmlSignatureAlgo;
    }

    public static byte[] sign(String stringToBeSigned, PrivateKey signingKey) throws GeneralSecurityException {
        if (stringToBeSigned == null) {
            throw logger.nullArgumentError("stringToBeSigned");
        }
        if (signingKey == null) {
            throw logger.nullArgumentError("signingKey");
        }
        String algo = signingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initSign(signingKey);
        sig.update(stringToBeSigned.getBytes());
        return sig.sign();
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, PublicKey validatingKey) throws GeneralSecurityException {
        if (signedContent == null) {
            throw logger.nullArgumentError("signedContent");
        }
        if (signatureValue == null) {
            throw logger.nullArgumentError("signatureValue");
        }
        if (validatingKey == null) {
            throw logger.nullArgumentError("validatingKey");
        }
        String algo = validatingKey.getAlgorithm();
        Signature sig = SignatureUtil.getSignature(algo);
        sig.initVerify(validatingKey);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    public static boolean validate(byte[] signedContent, byte[] signatureValue, String signatureAlgorithm, X509Certificate validatingCert) throws GeneralSecurityException {
        if (signedContent == null) {
            throw logger.nullArgumentError("signedContent");
        }
        if (signatureValue == null) {
            throw logger.nullArgumentError("signatureValue");
        }
        if (signatureAlgorithm == null) {
            throw logger.nullArgumentError("signatureAlgorithm");
        }
        if (validatingCert == null) {
            throw logger.nullArgumentError("validatingCert");
        }
        Signature sig = SignatureUtil.getSignature(signatureAlgorithm);
        sig.initVerify(validatingCert);
        sig.update(signedContent);
        return sig.verify(signatureValue);
    }

    private static Signature getSignature(String algo) throws GeneralSecurityException {
        Signature sig = null;
        if ("DSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance("SHA1withDSA");
        } else if ("RSA".equalsIgnoreCase(algo)) {
            sig = Signature.getInstance("SHA1withRSA");
        } else {
            throw logger.signatureUnknownAlgo(algo);
        }
        return sig;
    }
}

