/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import javax.validation.ValidatorFactory;
import org.jboss.as.ee.beanvalidation.BeanValidationAttachments;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.WeldLogger;
import org.jboss.as.weld.WeldMessages;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.services.bootstrap.HackValidationExtension;
import org.jboss.modules.Module;
import org.jboss.weld.metadata.MetadataImpl;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PrivateSubDeploymentMarker.isPrivate((DeploymentUnit)deploymentUnit) ? !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit) : (deploymentUnit.getParent() == null ? !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit) : !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit.getParent()))) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServicesAttachment services = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ClassLoader oldCl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            this.loadAttachments(services, module, deploymentUnit, topLevelDeployment);
            if (deploymentUnit.getParent() == null) {
                ValidatorFactory validatorFactory = (ValidatorFactory)deploymentUnit.getAttachment(BeanValidationAttachments.VALIDATOR_FACTORY);
                MetadataImpl metadata = new MetadataImpl((Object)new HackValidationExtension(validatorFactory), deploymentUnit.getName());
                topLevelDeployment.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
            }
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldCl);
        }
    }

    private void loadAttachments(ServicesAttachment servicesAttachment, Module module, DeploymentUnit deploymentUnit, DeploymentUnit topLevelDeployment) throws DeploymentUnitProcessingException {
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        List services = servicesAttachment.getServiceImplementations(Extension.class.getName());
        if (services == null) {
            return;
        }
        for (String service : services) {
            Extension extension = this.loadExtension(service, index, (ClassLoader)module.getClassLoader());
            if (extension == null) continue;
            MetadataImpl metadata = new MetadataImpl((Object)extension, deploymentUnit.getName());
            WeldLogger.DEPLOYMENT_LOGGER.debug("Loaded portable extension " + extension);
            topLevelDeployment.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
        }
    }

    private Extension loadExtension(String serviceClassName, DeploymentReflectionIndex index, ClassLoader loader) throws DeploymentUnitProcessingException {
        try {
            Class<?> clazz;
            Class<?> serviceClass = clazz = loader.loadClass(serviceClassName);
            Constructor ctor = index.getClassIndex(serviceClass).getConstructor(EMPTY_STRING_ARRAY);
            return (Extension)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw WeldMessages.MESSAGES.extensionDoesNotImplementExtension(serviceClassName, e);
        }
        catch (Exception e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, e);
        }
        catch (LinkageError e) {
            WeldLogger.DEPLOYMENT_LOGGER.couldNotLoadPortableExceptionClass(serviceClassName, e);
        }
        return null;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

