/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.discovery;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.weld.discovery.AnnotationType;
import org.jboss.as.weld.discovery.IndexAdapter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;

public class RequiredAnnotationTargetDiscovery {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final IndexAdapter index;

    public RequiredAnnotationTargetDiscovery(IndexAdapter index) {
        this.index = index;
    }

    public List<ClassInfo> getAffectedClasses(Iterable<AnnotationType> annotations) {
        ArrayList<ClassInfo> classes = new ArrayList<ClassInfo>();
        for (AnnotationType annotation : annotations) {
            this.getAffectedClasses(classes, annotation);
        }
        return classes;
    }

    protected List<ClassInfo> getAffectedClasses(List<ClassInfo> classes, AnnotationType annotation) {
        for (AnnotationInstance instance : this.index.getAnnotations(annotation.getName())) {
            AnnotationTarget target = instance.target();
            if (target instanceof ClassInfo) {
                this.processTopLevelClass(classes, (ClassInfo)target, annotation.isInherited());
                continue;
            }
            if (target instanceof FieldInfo) {
                this.processField(classes, (FieldInfo)target);
                continue;
            }
            if (target instanceof MethodInfo) {
                MethodInfo method = (MethodInfo)target;
                if (CONSTRUCTOR_NAME.equals(method.name())) {
                    this.processConstructor(classes, method);
                    continue;
                }
                this.processMethod(classes, method);
                continue;
            }
            if (!(target instanceof MethodParameterInfo)) continue;
            this.processParameter(classes, (MethodParameterInfo)target);
        }
        return classes;
    }

    protected void processTopLevelClass(List<ClassInfo> classes, ClassInfo clazz, boolean inherited) {
        classes.add(clazz);
        if (inherited) {
            this.processSubclasses(classes, clazz);
        }
    }

    protected void processSubclasses(List<ClassInfo> classes, ClassInfo clazz) {
        for (ClassInfo subclass : this.index.getKnownDirectSubclasses(clazz.name())) {
            classes.add(subclass);
            this.processSubclasses(classes, subclass);
        }
    }

    protected void processField(List<ClassInfo> classes, FieldInfo field) {
        classes.add(field.declaringClass());
        this.processSubclasses(classes, field.declaringClass());
    }

    protected void processMethod(List<ClassInfo> classes, MethodInfo method) {
        classes.add(method.declaringClass());
        this.processSubclasses(classes, method.declaringClass());
    }

    protected void processConstructor(List<ClassInfo> classes, MethodInfo method) {
        this.processMethod(classes, method);
    }

    protected void processParameter(List<ClassInfo> classes, MethodParameterInfo parameter) {
        classes.add(parameter.method().declaringClass());
        this.processSubclasses(classes, parameter.method().declaringClass());
    }
}

