/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.injection;

import java.io.Serializable;
import java.util.Map;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.weld.WeldMessages;
import org.jboss.weld.bean.ManagedBean;

public class WeldInjectionContext
implements Serializable {
    private final CreationalContext<?> context;
    private final Bean<?> bean;
    private final boolean delegateProduce;
    private final transient InjectionTarget injectionTarget;
    private final transient Map<Class<?>, InjectionTarget> interceptorInjections;

    public WeldInjectionContext(CreationalContext<?> ctx, Bean<?> bean, boolean delegateProduce, InjectionTarget injectionTarget, Map<Class<?>, InjectionTarget> interceptorInjections) {
        this.context = ctx;
        this.bean = bean;
        this.delegateProduce = delegateProduce;
        this.injectionTarget = injectionTarget;
        this.interceptorInjections = interceptorInjections;
    }

    public void inject(Object instance) {
        this.injectionTarget.inject(instance, this.context);
    }

    public WeldManagedReference produce() {
        if (this.delegateProduce && this.bean instanceof ManagedBean) {
            Object instance = ((ManagedBean)this.bean).getInjectionTarget().produce(this.context);
            return new WeldManagedReference(this.context, instance);
        }
        Object instance = this.injectionTarget.produce(this.context);
        return new WeldManagedReference(this.context, instance);
    }

    public void injectInterceptor(Object instance) {
        InjectionTarget injection = this.interceptorInjections.get(instance.getClass());
        if (injection == null) {
            throw WeldMessages.MESSAGES.unknownInterceptorClassForCDIInjection(instance.getClass());
        }
        injection.inject(instance, this.context);
    }

    public CreationalContext<?> getContext() {
        return this.context;
    }

    public InjectionTarget getInjectionTarget() {
        return this.injectionTarget;
    }

    public void release() {
        this.context.release();
    }

    private static final class WeldManagedReference
    implements ManagedReference,
    Serializable {
        private final CreationalContext<?> context;
        private final Object instance;

        private WeldManagedReference(CreationalContext<?> context, Object instance) {
            this.context = context;
            this.instance = instance;
        }

        public void release() {
            this.context.release();
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

