/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.controller.operations.deployment.AbstractDeploymentUploadHandler;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.server.controller.resources.DeploymentAttributes;
import org.jboss.dmr.ModelNode;

public class DeploymentUploadBytesHandler
extends AbstractDeploymentUploadHandler {
    public static final String OPERATION_NAME = "upload-deployment-bytes";

    private DeploymentUploadBytesHandler(ContentRepository repository) {
        super(repository, DeploymentAttributes.BYTES_NOT_NULL);
    }

    public static void registerMaster(ManagementResourceRegistration registration, ContentRepository repository) {
        new DeploymentUploadBytesHandler(repository).register(registration);
    }

    public static void registerSlave(ManagementResourceRegistration registration) {
        new DeploymentUploadBytesHandler(null).register(registration);
    }

    private void register(ManagementResourceRegistration registration) {
        registration.registerOperationHandler(DeploymentAttributes.DOMAIN_UPLOAD_BYTES_DEFINITION, (OperationStepHandler)this);
    }

    @Override
    protected InputStream getContentInputStream(OperationContext operationContext, ModelNode operation) throws OperationFailedException {
        byte[] bytes = operation.get("bytes").asBytes();
        return new ByteArrayInputStream(bytes);
    }
}

