/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class IgnoredNonAffectedServerGroupsUtil {
    private final ExtensionRegistry extensionRegistry;

    private IgnoredNonAffectedServerGroupsUtil(ExtensionRegistry extensionRegistry) {
        this.extensionRegistry = extensionRegistry;
    }

    public static IgnoredNonAffectedServerGroupsUtil create(ExtensionRegistry extensionRegistry) {
        return new IgnoredNonAffectedServerGroupsUtil(extensionRegistry);
    }

    public static ModelNode addCurrentServerGroupsToHostInfoModel(boolean ignoreUnaffectedServerGroups, Resource hostModel, ModelNode model) {
        if (!ignoreUnaffectedServerGroups) {
            return model;
        }
        model.get("ignore-unused-configuration").set(ignoreUnaffectedServerGroups);
        ModelNode initialServerGroups = new ModelNode();
        initialServerGroups.setEmptyObject();
        for (Resource.ResourceEntry entry : hostModel.getChildren("server-config")) {
            ModelNode serverNode = new ModelNode();
            serverNode.get("group").set(entry.getModel().get("group"));
            if (entry.getModel().hasDefined("socket-binding-group")) {
                serverNode.get("socket-binding-group").set(entry.getModel().get("socket-binding-group").asString());
            }
            initialServerGroups.get(entry.getName()).set(serverNode);
        }
        model.get("initial-server-groups").set(initialServerGroups);
        return model;
    }

    public boolean ignoreResource(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, PathAddress pathAddress) {
        if (pathAddress.size() != 1) {
            return false;
        }
        boolean ignore = this.ignoreResourceInternal(domainResource, serverConfigs, pathAddress);
        return ignore;
    }

    public boolean ignoreOperation(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, PathAddress pathAddress) {
        if (pathAddress.size() == 0) {
            return false;
        }
        boolean ignore = this.ignoreResourceInternal(domainResource, serverConfigs, pathAddress);
        return ignore;
    }

    public Set<PathElement> getAllExtensionsForProfile(Resource domainResource, PathElement profileElement) {
        Set extensionModuleNames = this.extensionRegistry.getExtensionModuleNames();
        HashSet<String> subsystemNamesForProfile = new HashSet<String>();
        for (Resource.ResourceEntry entry : domainResource.getChild(profileElement).getChildren("subsystem")) {
            subsystemNamesForProfile.add(entry.getName());
        }
        HashSet<PathElement> extensionsForProfile = new HashSet<PathElement>();
        for (String extensionModule : extensionModuleNames) {
            Map infos = this.extensionRegistry.getAvailableSubsystems(extensionModule);
            for (String subsystemName : infos.keySet()) {
                if (!subsystemNamesForProfile.contains(subsystemName)) continue;
                extensionsForProfile.add(PathElement.pathElement((String)"extension", (String)extensionModule));
            }
        }
        return extensionsForProfile;
    }

    private boolean ignoreResourceInternal(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, PathAddress pathAddress) {
        String type;
        switch (type = pathAddress.getElement(0).getKey()) {
            case "profile": {
                return this.ignoreProfile(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
            case "server-group": {
                return this.ignoreServerGroup(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
            case "extension": {
                return this.ignoreExtension(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
            case "socket-binding-group": {
                return this.ignoreSocketBindingGroups(domainResource, serverConfigs, pathAddress.getElement(0).getValue());
            }
        }
        return false;
    }

    private boolean ignoreProfile(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        HashSet<String> seenGroups = new HashSet<String>();
        for (ServerConfigInfo serverConfig : serverConfigs) {
            if (seenGroups.contains(serverConfig.getServerGroup())) continue;
            seenGroups.add(serverConfig.getServerGroup());
            Resource serverGroupResource = domainResource.getChild(PathElement.pathElement((String)"server-group", (String)serverConfig.getServerGroup()));
            if (!serverGroupResource.getModel().get("profile").asString().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreServerGroup(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        for (ServerConfigInfo serverConfig : serverConfigs) {
            if (!serverConfig.getServerGroup().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean ignoreExtension(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        Map subsystems = this.extensionRegistry.getAvailableSubsystems(name);
        for (String subsystem : subsystems.keySet()) {
            for (Resource.ResourceEntry profileEntry : domainResource.getChildren("profile")) {
                if (!profileEntry.hasChild(PathElement.pathElement((String)"subsystem", (String)subsystem)) || this.ignoreProfile(domainResource, serverConfigs, profileEntry.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean ignoreSocketBindingGroups(Resource domainResource, Collection<ServerConfigInfo> serverConfigs, String name) {
        for (ServerConfigInfo serverConfig : serverConfigs) {
            Resource serverGroupResource;
            if (!(serverConfig.getSocketBindingGroup() != null ? serverConfig.getSocketBindingGroup().equals(name) : name.equals((serverGroupResource = domainResource.getChild(PathElement.pathElement((String)"server-group", (String)serverConfig.getServerGroup()))).getModel().get("socket-binding-group").asString()))) continue;
            return false;
        }
        return true;
    }

    public Set<ServerConfigInfo> getServerConfigsOnSlave(Resource hostResource) {
        HashSet<ServerConfigInfo> groups = new HashSet<ServerConfigInfo>();
        for (Resource.ResourceEntry entry : hostResource.getChildren("server-config")) {
            groups.add(new ServerConfigInfoImpl(entry.getName(), entry.getModel()));
        }
        return groups;
    }

    public static ServerConfigInfo createServerConfigInfo(String name, String serverGroup, String socketBindingGroup) {
        return new ServerConfigInfoImpl(name, serverGroup, socketBindingGroup);
    }

    public static ServerConfigInfo createServerConfigInfo(ModelNode model) {
        String name = (String)model.keys().iterator().next();
        return new ServerConfigInfoImpl(name, model.get(name));
    }

    private static class ServerConfigInfoImpl
    implements ServerConfigInfo {
        private final String name;
        private final String serverGroup;
        private final String socketBindingGroup;

        ServerConfigInfoImpl(String name, ModelNode model) {
            this.name = name;
            this.serverGroup = model.get("group").asString();
            this.socketBindingGroup = model.has("socket-binding-group") ? model.get("socket-binding-group").asString() : null;
        }

        ServerConfigInfoImpl(String name, String serverGroup, String socketBindingGroup) {
            this.name = name;
            this.serverGroup = serverGroup;
            this.socketBindingGroup = socketBindingGroup;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getServerGroup() {
            return this.serverGroup;
        }

        @Override
        public String getSocketBindingGroup() {
            return this.socketBindingGroup;
        }

        @Override
        public ModelNode toModelNode() {
            ModelNode model = new ModelNode();
            model.get(new String[]{this.name, "group"}).set(this.serverGroup);
            if (this.socketBindingGroup != null) {
                model.get(new String[]{this.name, "socket-binding-group"}).set(this.socketBindingGroup);
            }
            return model;
        }
    }

    public static interface ServerConfigInfo {
        public String getName();

        public String getServerGroup();

        public String getSocketBindingGroup();

        public ModelNode toModelNode();
    }
}

