/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerLogger;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.GetAccessControlContextAction;
import org.xnio.OptionMap;

public class HttpManagementAddHandler
extends AbstractAddStepHandler {
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS) {
            attr.validateAndSet(operation, model);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        HttpManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        boolean onDemand = context.isBooting();
        boolean httpUpgrade = HttpManagementResourceDefinition.HTTP_UPGRADE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        HttpManagementAddHandler.installHttpManagementServices(context.getRunningMode(), context.getServiceTarget(), this.hostControllerInfo, this.environment, verificationHandler, onDemand, httpUpgrade, context.getServiceRegistry(false), newControllers);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        HttpManagementRemoveHandler.clearHostControllerInfo(this.hostControllerInfo);
        if (!context.isBooting()) {
            HttpManagementRemoveHandler.removeHttpManagementService(context);
        }
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setHttpManagementInterface(HttpManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = HttpManagementResourceDefinition.HTTP_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode securePortNode = HttpManagementResourceDefinition.HTTPS_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecurePort(securePortNode.isDefined() ? securePortNode.asInt() : -1);
        ModelNode realmNode = HttpManagementResourceDefinition.SECURITY_REALM.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecurityRealm(realmNode.isDefined() ? realmNode.asString() : null);
    }

    public static void installHttpManagementServices(RunningMode runningMode, ServiceTarget serviceTarget, LocalHostControllerInfo hostControllerInfo, HostControllerEnvironment environment, ServiceVerificationHandler verificationHandler, boolean onDemand, boolean httpUpgrade, ServiceRegistry serviceRegistry, List<ServiceController<?>> newControllers) {
        String interfaceName = hostControllerInfo.getHttpManagementInterface();
        int port = hostControllerInfo.getHttpManagementPort();
        int securePort = hostControllerInfo.getHttpManagementSecurePort();
        String securityRealm = hostControllerInfo.getHttpManagementSecurityRealm();
        HostControllerLogger.AS_ROOT_LOGGER.creatingHttpManagementService(interfaceName, port, securePort);
        JBossThreadFactory httpMgmtThreads = new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, (AccessControlContext)AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        ConsoleMode consoleMode = ConsoleMode.CONSOLE;
        if (runningMode == RunningMode.ADMIN_ONLY) {
            consoleMode = ConsoleMode.ADMIN_ONLY;
        } else if (!hostControllerInfo.isMasterDomainController()) {
            consoleMode = ConsoleMode.SLAVE_HC;
        }
        UndertowHttpManagementService service = new UndertowHttpManagementService(consoleMode, environment.getProductConfig().getConsoleSlot(), httpUpgrade);
        ServiceBuilder builder = serviceTarget.addService(UndertowHttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addDependency(DomainModelControllerService.SERVICE_NAME, ModelController.class, service.getModelControllerInjector()).addDependency(ControlledProcessStateService.SERVICE_NAME, ControlledProcessStateService.class, (Injector)service.getControlledProcessStateServiceInjector()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)httpMgmtThreads));
        ServiceName realmSvcName = null;
        if (securityRealm != null) {
            realmSvcName = SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm});
            builder.addDependency(realmSvcName, SecurityRealmService.class, (Injector)service.getSecurityRealmInjector());
        } else {
            HostControllerLogger.AS_ROOT_LOGGER.noSecurityRealmDefined();
        }
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        builder.setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE).install();
        if (httpUpgrade) {
            ServiceName serverCallbackService = ServiceName.JBOSS.append(new String[]{"host", "controller", "server-inventory", "callback"});
            ServiceName tmpDirPath = ServiceName.JBOSS.append(new String[]{"server", "path", "jboss.domain.temp.dir"});
            ManagementRemotingServices.installSecurityServices((ServiceTarget)serviceTarget, (String)"http-management", (ServiceName)realmSvcName, (ServiceName)serverCallbackService, (ServiceName)tmpDirPath, (ServiceVerificationHandler)verificationHandler, newControllers);
            NativeManagementServices.installRemotingServicesIfNotInstalled(serviceTarget, hostControllerInfo.getLocalHostName(), verificationHandler, null, serviceRegistry, onDemand);
            RemotingHttpUpgradeService.installServices((ServiceTarget)serviceTarget, (String)"http-management", (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)OptionMap.EMPTY, (ServiceVerificationHandler)verificationHandler);
        }
    }
}

