/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.LocalHostControllerInfo;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.as.host.controller.HostControllerMessages;
import org.jboss.as.host.controller.MasterDomainControllerClient;
import org.jboss.as.host.controller.resources.ServerConfigResourceDefinition;
import org.jboss.dmr.ModelNode;

public abstract class ServerRestartRequiredServerConfigWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    public static final ServerRestartRequiredServerConfigWriteAttributeHandler SOCKET_BINDING_PORT_OFFSET_INSTANCE = new SocketBindingPortOffsetHandler();
    private final AttributeDefinition attributeDefinition;

    protected ServerRestartRequiredServerConfigWriteAttributeHandler(AttributeDefinition attributeDefinition) {
        super(new AttributeDefinition[]{attributeDefinition});
        this.attributeDefinition = attributeDefinition;
    }

    public static ServerRestartRequiredServerConfigWriteAttributeHandler createGroupInstance(LocalHostControllerInfo hostControllerInfo) {
        return new GroupHandler(hostControllerInfo);
    }

    public static ServerRestartRequiredServerConfigWriteAttributeHandler createSocketBindingGroupInstance(LocalHostControllerInfo hostControllerInfo) {
        return new SocketBindingGroupHandler(hostControllerInfo);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, Resource resource) throws OperationFailedException {
        if (newValue.equals(currentValue)) {
            ServerOperationResolver.addToDontPropagateToServersAttachment(context, operation);
        }
        ModelNode resolvedValue = this.attributeDefinition.resolveModelAttribute(context, resource.getModel());
        this.validateReferencedNewValueExists(context, operation, currentValue, resolvedValue);
    }

    protected abstract void validateReferencedNewValueExists(OperationContext var1, ModelNode var2, ModelNode var3, ModelNode var4) throws OperationFailedException;

    private static void pullDownMissingDataFromDc(OperationContext context, final String serverName, final String serverGroupName, final String socketBindingGroupName) {
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                MasterDomainControllerClient masterDomainControllerClient = (MasterDomainControllerClient)context.getServiceRegistry(false).getRequiredService(MasterDomainControllerClient.SERVICE_NAME).getValue();
                masterDomainControllerClient.pullDownDataForUpdatedServerConfigAndApplyToModel(context, serverName, serverGroupName, socketBindingGroupName);
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
                        if (!root.hasChild(PathElement.pathElement((String)"server-group", (String)serverGroupName))) {
                            throw HostControllerMessages.MESSAGES.noServerGroupCalled(serverGroupName);
                        }
                        if (socketBindingGroupName != null && !root.hasChild(PathElement.pathElement((String)"socket-binding-group", (String)socketBindingGroupName))) {
                            throw HostControllerMessages.MESSAGES.noSocketBindingGroupCalled(socketBindingGroupName);
                        }
                        context.stepCompleted();
                    }
                }, OperationContext.Stage.MODEL);
                context.stepCompleted();
            }
        }, OperationContext.Stage.MODEL);
    }

    private static class SocketBindingPortOffsetHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        public SocketBindingPortOffsetHandler() {
            super((AttributeDefinition)ServerConfigResourceDefinition.SOCKET_BINDING_PORT_OFFSET);
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode operation, ModelNode currentValue, ModelNode resolvedValue) throws OperationFailedException {
        }
    }

    private static class SocketBindingGroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        final LocalHostControllerInfo hostControllerInfo;

        public SocketBindingGroupHandler(LocalHostControllerInfo hostControllerInfo) {
            super((AttributeDefinition)ServerConfigResourceDefinition.SOCKET_BINDING_GROUP);
            this.hostControllerInfo = hostControllerInfo;
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode operation, ModelNode currentValue, ModelNode resolvedValue) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (resolvedValue.isDefined() && !context.isBooting() && resolvedValue.isDefined() && root.getChild(PathElement.pathElement((String)"socket-binding-group", (String)resolvedValue.asString())) == null) {
                if (this.hostControllerInfo.isMasterDomainController() || !this.hostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                    throw HostControllerMessages.MESSAGES.noSocketBindingGroupCalled(resolvedValue.asString());
                }
                String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                String serverGroupName = model.require("group").asString();
                ServerRestartRequiredServerConfigWriteAttributeHandler.pullDownMissingDataFromDc(context, serverName, serverGroupName, resolvedValue.asString());
            }
        }
    }

    private static class GroupHandler
    extends ServerRestartRequiredServerConfigWriteAttributeHandler {
        final LocalHostControllerInfo hostControllerInfo;

        public GroupHandler(LocalHostControllerInfo hostControllerInfo) {
            super((AttributeDefinition)ServerConfigResourceDefinition.GROUP);
            this.hostControllerInfo = hostControllerInfo;
        }

        @Override
        protected void validateReferencedNewValueExists(OperationContext context, ModelNode operation, ModelNode currentValue, ModelNode resolvedValue) throws OperationFailedException {
            Resource root = context.readResourceFromRoot(PathAddress.EMPTY_ADDRESS, false);
            if (!context.isBooting() && root.getChild(PathElement.pathElement((String)"server-group", (String)resolvedValue.asString())) == null) {
                if (this.hostControllerInfo.isMasterDomainController() || !this.hostControllerInfo.isRemoteDomainControllerIgnoreUnaffectedConfiguration()) {
                    throw HostControllerMessages.MESSAGES.noServerGroupCalled(resolvedValue.asString());
                }
                String serverName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
                ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                String socketBindingGroupName = model.hasDefined("socket-binding-group") ? model.get("socket-binding-group").asString() : null;
                ServerRestartRequiredServerConfigWriteAttributeHandler.pullDownMissingDataFromDc(context, serverName, resolvedValue.asString(), socketBindingGroupName);
            }
        }
    }
}

